<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Parâmetros</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/fontawesome-free/css/all.min.css?versao=3.259.2.1">
  <!-- Ionicons -->
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css?versao=3.259.2.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/adminlte.min.css?versao=3.259.2.1">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.259.2.1">
  <!-- Daterange picker -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/custom.css?versao=3.259.2.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/sisplan.css?versao=3.259.2.1">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/dist/css/dataTables.bootstrap4.min.css?versao=3.259.2.1" />
  <link rel="shortcut icon" href="<?php echo BASE_URI; ?>/favicon.ico">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/jquery-ui.css?versao=3.259.2.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.259.2.1">
  <!-- Google Font: Source Sans Pro -->
  <style>
    .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    }

    div .nav-pills .nav-link.active,
    div .nav-pills .show>.nav-link {
      color: #fff;
      background-color: #a1a6ab;
    }

    .nave.nav-link:hover {
      color: #6c757d !important;
    }

    .nave.nav-link.active:hover {
      color: white !important;
    }

    .group-default {
      margin: 0px;
    }

    label:hover {
      cursor: pointer;
    }

    label {
      width: 750px;
    }

    #inputSisplanFiscal {
      display: flex;
      overflow: auto;
      white-space: nowrap;
    }

    #inputSisplanFiscal input {
      width: 30px;
      margin-right: 3px;
    }

    .scrollParams {
      max-height: 100vh;
      overflow-y: auto;
    }

    .content-wrapper {
      margin-left: 0px !important;
    }

    .main-header,
    .main-sidebar,
    footer {
      display: none;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1 class="m-0 text-dark">Parâmetros</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">

            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="card">
          <div class="card-body">
            <div class="row">
              <div class="col-sm-3">
                <div class="nav flex-column nav-pills divParametros" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                  <a class="nave nav-link active" tipoParametro="ENTIDADE" id="v-pills-entidade-tab" data-toggle="pill" href="#v-pills-entidade" role="tab" aria-controls="v-pills-entidade" aria-selected="true">Entidade</a>
                  <a class="nave nav-link" tipoParametro="VENDA" id="v-pills-venda-tab" data-toggle="pill" href="#v-pills-venda" role="tab" aria-controls="v-pills-venda" aria-selected="false">Venda PDV</a>
                  <a class="nave nav-link" tipoParametro="RECEBER" id="v-pills-receber-tab" data-toggle="pill" href="#v-pills-receber" role="tab" aria-controls="v-pills-receber" aria-selected="false">Financeiro</a>
                  <a class="nave nav-link" tipoParametro="FATURAMENTO" id="v-pills-faturamento-tab" data-toggle="pill" href="#v-pills-faturamento" role="tab" aria-controls="v-pills-faturamento" aria-selected="false">Faturamento</a>
                  <a class="nave nav-link" tipoParametro="PRODUTO" id="v-pills-produto-tab" data-toggle="pill" href="#v-pills-produto" role="tab" aria-controls="v-pills-produto" aria-selected="false">Produto</a>
                  <a class="nave nav-link" tipoParametro="MATERIAL" id="v-pills-material-tab" data-toggle="pill" href="#v-pills-material" role="tab" aria-controls="v-pills-material" aria-selected="false">Material</a>
                  <a class="nave nav-link" tipoParametro="ORDEMPRODUCAO" id="v-pills-faccao-tab" data-toggle="pill" href="#v-pills-faccao" role="tab" aria-controls="v-pills-faccao" aria-selected="false">Ordem Produção / Facção</a>
                  <a class="nave nav-link" tipoParametro="PEDIDO" id="v-pills-pedido-tab" data-toggle="pill" href="#v-pills-pedido" role="tab" aria-controls="v-pills-pedido" aria-selected="false">Comercial</a>
                  <a class="nave nav-link" tipoParametro="PEDIDOB2B" id="v-pills-pedidob2b-tab" data-toggle="pill" href="#v-pills-pedidob2b" role="tab" aria-controls="v-pills-pedidob2b" aria-selected="false">Pedido B2B</a>
                  <a class="nave nav-link" tipoParametro="EXPEDICAO" id="v-pills-expedicao-tab" data-toggle="pill" href="#v-pills-expedicao" role="tab" aria-controls="v-pills-expedicao" aria-selected="false">Expedição</a>
                  <a class="nave nav-link" tipoParametro="ESCRITURAL" id="v-pills-escritural-tab" data-toggle="pill" href="#v-pills-escritural" role="tab" aria-controls="v-pills-escritural" aria-selected="false">Escritural</a>
                  <a class="nave nav-link" tipoParametro="SISPLANFISCAL" id="v-pills-sisplanFiscal-tab" data-toggle="pill" href="#v-pills-sisplanFiscal" role="tab" aria-controls="v-pills-sisplanFiscal" aria-selected="false" title="Parâmetros de configuração do Sisplan Fiscal, projeto separado do Sisplan Web">Sisplan Fiscal (SPED / Sintegra)</a>
                  <a class="nave nav-link" tipoParametro="CONTABIL" id="v-pills-contabil-tab" data-toggle="pill" href="#v-pills-contabil" role="tab" aria-controls="v-pills-contabil" aria-selected="false">Contábil</a>
                  <a class="nave nav-link" tipoParametro="SISTEMA" id="v-pills-sistema-tab" data-toggle="pill" href="#v-pills-sistema" role="tab" aria-controls="v-pills-sistema" aria-selected="false">Sistema</a>
                  <a class="nave nav-link" tipoParametro="COMPRAS" id="v-pills-compras-tab" data-toggle="pill" href="#v-pills-compras" role="tab" aria-controls="v-pills-compras" aria-selected="false">Compras</a>
                  <a class="nave nav-link" tipoParametro="CUSTOS" id="v-pills-custos-tab" data-toggle="pill" href="#v-pills-custos" role="tab" aria-controls="v-pills-custos" aria-selected="false">Custos</a>
                  <button class="btn btn-sisp btn-danger d-none" id="btn-exportar">Exportar Parâmetros</button>
                </div>
              </div>
              <div class="col-sm-9">
                <div class="tab-content" id="v-pills-tabContent">

                  <div class="tab-pane fade primary-color-dark semi-bold" id="v-pills-venda" role="tabpanel" aria-labelledby="v-pills-venda-tab">
                    <div id="loja_content" class="scrollParams">
                      <div class="card group-default">
                        <div class="card-header" id="param1" data-target="#collapse-param1" data-toggle="collapse">
                          <label for="loja_utiliza_barra_balanca">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param1">
                              01. Habilitar a opção de bipar barra com balança
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param1" class="collapse" aria-labelledby="param1" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Habilita a opção de quando bipada a barra, pegar o código do produto e peso da balança e automaticamente preencher os campos.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_utiliza_barra_balanca" name="loja_utiliza_barra_balanca">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param2" data-target="#collapse-param2" data-toggle="collapse">
                          <label for="loja_deposito_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param2">
                              02. Depósito padrão para venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param2" class="collapse" aria-labelledby="param2" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Depósito padrão utilizado para validar estoque.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtDeposito">Depósito</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtDeposito" name="txtDeposito" class="form-control" placeholder="Depósito">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-deposito" name="btn-deposito" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-deposito" name="btn-limpa-deposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param3" data-target="#collapse-param3" data-toggle="collapse">
                          <label for="loja_deposito_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param3">
                              03. Tabela de preço padrão para venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param3" class="collapse" aria-labelledby="param3" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Tabela de preço padrão utilizada para determinar o preço de venda do produto.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtTabela">Tabela</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtTabela" name="txtTabela" class="form-control" placeholder="Tabela">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-tabela" name="btn-tabela" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-tabela" name="btn-limpa-tabela" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param4" data-target="#collapse-param4" data-toggle="collapse">
                          <label for="loja_cliente_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param4">
                              04. Cliente padrão para venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param4" class="collapse" aria-labelledby="param4" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Cliente padrão para já trazer preenchido ao efetuar uma venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtCliente">Cliente</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-cliente" name="btn-cliente" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-cliente" name="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param5" data-target="#collapse-param5" data-toggle="collapse">
                          <label for="loja_controla_estoque">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param5">
                              05. Controle de Estoque
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param5" class="collapse" aria-labelledby="param5" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define como será o controle de estoque ao bipar o item na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_controla_estoque" name="loja_controla_estoque">
                                <option value="0">Bloqueia estoque negativo</option>
                                <option value="1">Permite estoque negativo</option>
                                <option value="2">Permite estoque negativo sem mensagem</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param6" data-target="#collapse-param6" data-toggle="collapse">
                          <label for="loja_tipo_tabela">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param6">
                              06. Tipo de Tabela de Preço
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param6" class="collapse" aria-labelledby="param6" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define qual será o Tipo de Tabela de Preço utilizado na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_tipo_tabela" name="loja_tipo_tabela">
                                <option value="0">Tabela de preço normal</option>
                                <option value="1">Tabela de preço por cor e tamanho</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param7" data-target="#collapse-param7" data-toggle="collapse">
                          <label for="loja_gerar_nfce">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param7">
                              07. Utiliza NFC-e
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param7" class="collapse" aria-labelledby="param7" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a loja usa ou não a opção de NFC-e, e é possível ainda automatizar a geração.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_gerar_nfce" name="loja_gerar_nfce">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Automático</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param8" data-target="#collapse-param8" data-toggle="collapse">
                          <label for="nfce_natureza_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param8">
                              08. Natureza padrão para NFC-e
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param8" class="collapse" aria-labelledby="param8" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Natureza padrão para já trazer preenchido ao gerar uma NFC-e.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtNaturezaNFCE">Natureza</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtNaturezaNFCE" name="txtNaturezaNFCE" class="form-control" placeholder="Natureza">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-NaturezaNFCE" name="btn-NaturezaNFCE" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-NaturezaNFCE" name="btn-limpa-NaturezaNFCE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param9" data-target="#collapse-param9" data-toggle="collapse">
                          <label for="loja_ecf">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param9">
                              09. Utiliza Impressora Fiscal
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param9" class="collapse" aria-labelledby="param9" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a loja usa ou não Impressora Fiscal. </br> Obs: Configurar porta da api do cupom no arquivo config.php.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_ecf" name="loja_ecf">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <!-- // -->
                      <div class="card group-default">
                        <div class="card-header" id="param10" data-target="#collapse-param10" data-toggle="collapse">
                          <label for="loja_desc_super">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param10">
                              10. Solicitar senha de supervisor para dar desconto no item da venda.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param10" class="collapse" aria-labelledby="param10" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se ao dar desconto em um item da venda, será solicitado senha de supervisor ou não.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_desc_super" name="loja_desc_super">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <!-- // -->
                      <div class="card group-default d-none">
                        <!-- Removido parametro abaixo... -->
                        <div class="card-header" id="param11" data-target="#collapse-param11" data-toggle="collapse">
                          <label for="loja_desc_super_2">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param11">
                              11. Solicitar senha de supervisor para estornar/excluir item da venda.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param11" class="collapse" aria-labelledby="param11" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se ao estornar/excluir um item da venda, será solicitado senha de supervisor ou não.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_desc_super_2" name="loja_desc_super_2">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <!-- // -->
                      <div class="card group-default">
                        <div class="card-header" id="param12" data-target="#collapse-param12" data-toggle="collapse">
                          <label for="imprimir_cupom_gerencial">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param12">
                              12. Imprimir cupom gerencial
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param12" class="collapse" aria-labelledby="param12" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se após imprimir o cupom fiscal, será impresso um cupom gerencial da venda.<br>
                                  OBS: necessário configurar moeda para imprimir cupom gerencial.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="imprimir_cupom_gerencial" name="imprimir_cupom_gerencial">
                                <option value="0">Não</option>
                                <option value="1">Sim - Cupom de Recebimento </option>
                                <option value="2">Sim - Cupom de Itens </option>
                                <option value="3">Sim - Cupom Completo </option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param13" data-target="#collapse-param13" data-toggle="collapse">
                          <label for="utilizar_guia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param13">
                              13. Utilizar Guia
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param13" class="collapse" aria-labelledby="param13" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é utilizado o campo guia dentro da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="utilizar_guia" name="utilizar_guia">
                                <option value="0">Não </option>
                                <option value="1">Sim - Preenchimento obrigatório </option>
                                <option value="2">Sim - Preenchimento não obrigatório </option>
                                <option value="3">Sim - Considera representante do cliente - Preenchimento obrigatório </option>
                                <option value="4">Sim - Considera representante do cliente - Preenchimento não obrigatório </option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param14" data-target="#collapse-param14" data-toggle="collapse">
                          <label for="obrigar_devolucao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param14">
                              14. Obrigar a associação de uma venda na devolução de um item
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param14" class="collapse" aria-labelledby="param14" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é obrigatório informar o número da venda do item a ser devolvido na tela de devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="obrigar_devolucao" name="obrigar_devolucao">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param15" data-target="#collapse-param15" data-toggle="collapse">
                          <label for="moeda_devolucao_automatica">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param15">
                              15. Moeda Troca Automática
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param15" class="collapse" aria-labelledby="param15" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Moeda de troca para utilizar antecipação automaticamente. <br>
                                  OBS: Necessário vincular uma condição de pagamento no cadastro dessa moeda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtMoedaTroca">Moeda Troca</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtMoedaTroca" name="txtMoedaTroca" class="form-control" placeholder="Moeda">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-MoedaTroca" name="btn-MoedaTroca" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-MoedaTroca" name="btn-limpa-MoedaTroca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param16" data-target="#collapse-param16" data-toggle="collapse">
                          <label for="txtMsgTrocaCabecario">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param16">
                              16. Mensagem cupom de troca (cabeçalho)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param16" class="collapse" aria-labelledby="param16" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Mensagem do cabeçalho no cupom de troca.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-11">
                              <textarea style="resize: none" id="txtMsgTrocaCabecario" class="input-default focus form-control parametroVenda" rows="3">
                                                            </textarea>
                            </div>
                            <div class="col-sm-1">
                              <button id="btn-cabecario" class="btn btn-sm btn-danger d-none" title="Quebrar Linha"><i class="fas fa-level-down-alt"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param17" data-target="#collapse-param17" data-toggle="collapse">
                          <label for="txtMsgTrocaRodape">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param17">
                              17. Mensagem cupom de troca (rodapé)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param17" class="collapse" aria-labelledby="param17" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Mensagem do rodapé no cupom de troca.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-11">
                              <textarea style="resize: none" id="txtMsgTrocaRodape" class="input-default focus form-control parametroVenda" rows="3">
                                                            </textarea>
                            </div>
                            <div class="col-sm-1">
                              <button id="btn-rodape" class="btn btn-sm btn-danger d-none" title="Quebrar Linha"><i class="fas fa-level-down-alt"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param22" data-target="#collapse-param22" data-toggle="collapse">
                          <label for="vendaProdutoMaterial">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param22">
                              18. Venda de Produto ou Material
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param22" class="collapse" aria-labelledby="param22" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Da prioridade nas pesquisas entre produto ou material na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="vendaProdutoMaterial" name="vendaProdutoMaterial">
                                <option value="0">Produto</option>
                                <option value="1">Material</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param18" data-target="#collapse-param18" data-toggle="collapse">
                          <label for="loja_gerar_nfce">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param18">
                              19. Utiliza CF-e
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param18" class="collapse" aria-labelledby="param18" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a loja usa ou não a opção de CF-e SAT.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_gerar_cfe" name="loja_gerar_cfe">
                                <option value="0">Não</option>
                                <option value="1">SAT</option>
                                <option value="3">SAT Automático</option>
                                <option value="5">SAT - Não abre tela de impressão CF-e ao finalizar a venda</option>
                                <option value="6">SAT Automático - Não abre tela de impressão CF-e ao finalizar a venda</option>
                                <option value="2">MFE</option>
                                <option value="4">MFE Automático</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param19" data-target="#collapse-param19" data-toggle="collapse">
                          <label for="nfce_natureza_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param19">
                              20. Natureza padrão para CF-e
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param19" class="collapse" aria-labelledby="param19" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Natureza padrão para já trazer preenchido ao gerar uma CF-e.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtNaturezaCFe">Natureza</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtNaturezaCFe" name="txtNaturezaCFe" class="form-control" placeholder="Natureza">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-NaturezaCFe" name="btn-NaturezaCFe" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-NaturezaCFe" name="btn-limpa-NaturezaCFe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param20" data-target="#collapse-param20" data-toggle="collapse">
                          <label for="nfe_venda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param20">
                              21. NF-e na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param20" class="collapse" aria-labelledby="param20" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é possível faturar uma venda dentro da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="nfe_venda" name="nfe_venda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Sim - Somente na Devolução</option>
                                <option value="3">Sim - Gerar automático</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param21" data-target="#collapse-param21" data-toggle="collapse">
                          <label for="qtde_venda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param20">
                              22. Quantidade ao adicionar produto
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param21" class="collapse" aria-labelledby="param21" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Torna visível o campo de quantidade e define em qual campo focar ao adicionar produto.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="qtde_venda" name="qtde_venda">
                                <option value="0">Não</option>
                                <option value="1">Sim - Focar na Quantidade</option>
                                <option value="2">Sim - Focar na Barra</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <!-- pulado para id 23 pois o 22 foi usado na ordem incorreta -->
                      <div class="card group-default">
                        <div class="card-header" id="param23" data-target="#collapse-param23" data-toggle="collapse">
                          <label for="bloqueio_limite_credito">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param23">
                              23. Limite de crédito ao finalizar venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param23" class="collapse" aria-labelledby="param23" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define como o sistema deve tratar o limite de crédito do cliente na finalização da venda.
                                  <p><b style="font-size: 14px;">Moeda Tem que ser crediário ou cheque</b></p>
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="bloqueio_limite_credito" name="bloqueio_limite_credito">
                                <option value="0">Dar mensagem e permitir finalizar a venda</option>
                                <option value="1">Dar mensagem e bloquear a finalização da venda</option>
                                <option value="2">Dar mensagem e permitir apenas com senha de supervisor </option>
                                <option value="3">Não controlar </option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param24" data-target="#collapse-param24" data-toggle="collapse">
                          <label for="bloqueia_cliente_atrasado">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param24">
                              24. Cliente com duplicatas em atraso
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param24" class="collapse" aria-labelledby="param24" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é possível fazer uma venda com um cliente que possui duplicatas em atraso.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="bloqueia_cliente_atrasado" name="bloqueia_cliente_atrasado">
                                <option value="0">Dar mensagem e permitir seguir</option>
                                <option value="1">Dar mensagem e bloquear</option>
                                <option value="2">Dar mensagem e permitir seguir apenas com senha de supervisor </option>
                                <option value="3">Não controlar </option>
                                <option value="4">Dar mensagem e sugerir atalho para baixa de duplicatas </option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param25" data-target="#collapse-param25" data-toggle="collapse">
                          <label for="taxa_juros">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param25">
                              25. Taxa de juros duplicata
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param25" class="collapse" aria-labelledby="param25" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define de onde busca taxa de juros ao gerar as duplicatas da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="taxa_juros" name="taxa_juros">
                                <option value="0"> </option>
                                <option value="1">Cadastro de empresa</option>
                                <option value="2">Cadastro de cliente</option>
                                <option value="3">Cadastro de moeda</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param26" data-target="#collapse-param26" data-toggle="collapse">
                          <label for="utiliza_pafConferencia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param26">
                              26. Conferência de Venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param26" class="collapse" aria-labelledby="param26" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é utilizado ou não conferência de venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="utiliza_pafConferencia" name="utiliza_pafConferencia">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Permite desistir da conferência com senha de supervisor</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param28" data-target="#collapse-param28" data-toggle="collapse">
                          <label for="utiliza_acrescimoVenda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param28">
                              27. Permite Acréscimo na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param28" class="collapse" aria-labelledby="param28" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é utilizado acréscimo ou não na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="utiliza_acrescimoVenda" name="utiliza_acrescimoVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param29" data-target="#collapse-param29" data-toggle="collapse">
                          <label for="imprimir_venda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param29">
                              28. Imprimir venda pendente
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param29" class="collapse" aria-labelledby="param29" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai imprimir a venda pendente.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="imprimir_venda" name="imprimir_venda">
                                <option value="0">Sempre imprimir</option>
                                <option value="1">Nunca imprimir</option>
                                <option value="2">Perguntar se deseja imprimir</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param30" data-target="#collapse-param30" data-toggle="collapse">
                          <label for="bloquear_consumidorFinal">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param30">
                              29. Lançar moeda do tipo crediário/cheque para Consumidor Final
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param30" class="collapse" aria-labelledby="param30" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se utiliza moeda do tipo crediário/cheque para Consumidor Final dentro da Venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="imprimir_venda" name="imprimir_venda">
                                <option value="0">Permitir</option>
                                <option value="1">Bloquear</option>
                                <option value="2">Perguntar se deseja lançar</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param31" data-target="#collapse-param31" data-toggle="collapse">
                          <label for="regra_promocao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param31">
                              30. Utiliza Regra de Promoção na Venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param31" class="collapse" aria-labelledby="param31" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai usar Regra de Promoção na Venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="regra_promocao" name="regra_promocao">
                                <option value="0">Não</option>
                                <option value="1">Sim - Regra definida na venda</option>
                                <option value="2">Sim - Validar todas as regras ativas</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param32" data-target="#collapse-param32" data-toggle="collapse">
                          <label for="">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param32">
                              31. Bloqueia fechamento de caixa com venda pendente
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param32" class="collapse" aria-labelledby="param32" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Não deixa fechar o caixa com venda pendente.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param34" data-target="#collapse-param34" data-toggle="collapse">
                          <label for="">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param34">
                              32. Permite informar valor de frete na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param34" class="collapse" aria-labelledby="param34" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Informar valor de frete na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param35" data-target="#collapse-param35" data-toggle="collapse">
                          <label for="">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param35">
                              33. Permite cadastrar preço na tabela de preço
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param35" class="collapse" aria-labelledby="param35" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Permite cadastrar preço na tabela de preço.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Sim</option>
                                <option value="1">Não</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param36" data-target="#collapse-param36" data-toggle="collapse">
                          <label for="">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param36">
                              34. Descontar duplicatas em aberto ao finalizar uma devolução
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param36" class="collapse" aria-labelledby="param36" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Permite descontar as duplicatas em aberto ao finalizar a devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param37" data-target="#collapse-param37" data-toggle="collapse">
                          <label for="imprimir_venda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param37">
                              35. Imprimir Romaneio
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param37" class="collapse" aria-labelledby="param37" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai imprimir o romaneio.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="imprimir_vendaRomaneio" name="imprimir_vendaRomaneio">
                                <option value="0">Sempre imprimir</option>
                                <option value="1">Nunca imprimir</option>
                                <option value="2">Perguntar se deseja imprimir</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param37" data-target="#collapse-param38" data-toggle="collapse">
                          <label for="imprimir_venda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param38">
                              36. Alterar Quantidade do item.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param38" class="collapse" aria-labelledby="param38" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Habilita Opção para alterar quantidade do item.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="quantidadeGrid" name="quantidadeGrid">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param32" data-target="#collapse-param39" data-toggle="collapse">
                          <label for="">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param39">
                              37. Bloqueia fechamento de caixa com documento fiscal não transmitido
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param39" class="collapse" aria-labelledby="param39" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Não deixa fechar o caixa com venda sem documento fiscal vinculado ou com documento fiscal não transmitido.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim - Vendas sem documento fiscal vinculado ou documento fiscal não transmitido</option>
                                <option value="2">Sim - Somente documentos fiscais não transmitidos</option>
                                <option value="3">Sim - Vendas e Devoluções sem documento fiscal vinculado ou documento fiscal não transmitido</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param40" data-target="#collapse-param40" data-toggle="collapse">
                          <label for="utilizaStatus">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param40">
                              38. Utiliza Status
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param40" class="collapse" aria-labelledby="param40" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é utilizado o campo status dentro da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="utilizaStatus" name="utilizaStatus">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param40" data-target="#collapse-param41" data-toggle="collapse">
                          <label for="enviaReceberEmpDemo">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param41">
                              39. Envia receber para empresa demonstração
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param41" class="collapse" aria-labelledby="param41" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o receber vai para a empresa de demonstração.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="enviaReceberEmpDemo" name="enviaReceberEmpDemo">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Sim - controle por moeda</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param42" data-target="#collapse-param42" data-toggle="collapse">
                          <label for="utilizaVendedorItem">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param42">
                              40. Utiliza Vendedor por Item
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param42" class="collapse" aria-labelledby="param42" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Habilita campo de vendedor na aba dos itens.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="utilizaVendedorItem" name="utilizaVendedorItem">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param43" data-target="#collapse-param43" data-toggle="collapse">
                          <label for="utilizaVendedorItem">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param43">
                              41. Cadastra cliente sem CPF/CNPJ
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param43" class="collapse" aria-labelledby="param43" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Permite Cadastrar cliente sem CPF/CNPJ.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="clienteSemCPFCNPJ" name="clienteSemCPFCNPJ">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param44" data-target="#collapse-param44" data-toggle="collapse">
                          <label for="utilizaVendedorItem">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param44">
                              42. Qualidade ao adicionar item na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param44" class="collapse" aria-labelledby="param44" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Torna visível o campo de qualidade na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="qualidadeVenda" name="qualidadeVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param45" data-target="#collapse-param45" data-toggle="collapse">
                          <label for="utilizaVendedorItem">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param45">
                              43. Emite Bloco X
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param45" class="collapse" aria-labelledby="param45" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">

                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="emiteBlocoXautomatico" name="emiteBlocoXautomatico">
                                <option value="0">Não</option>
                                <option value="1">Sim - Redução Z</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param46" data-target="#collapse-param46" data-toggle="collapse">
                          <label for="utilizaVendedorItem">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param46">
                              44. Permite alterar o preço do item na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param46" class="collapse" aria-labelledby="param46" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Permite alterar o preço do item na venda
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="permiteAlterarPreco" name="permiteAlterarPreco">
                                <option value="0">Não</option>
                                <option title="Ao selecionar essa opção, será possível alterar o preço dentro da opção 'Desconto' no menu ações do item, onde a diferença do preço original será aplicada como desconto." value="1">Sim - Aplicando desconto</option>
                                <option title="Ao selecionar essa opção, será disponibilizado uma opção 'Alterar Preço' no menu Ações do item, onde não será aplicado a diferença como desconto." value="2">Sim - Sem aplicar desconto</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param47" data-target="#collapse-param47" data-toggle="collapse">
                          <label for="habilitaPesquisaConferencia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param46">
                              45. Habilita campo de pesquisa do Produto na hora da Conferência
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param47" class="collapse" aria-labelledby="param47" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Habilita campo de pesquisa do Produto na hora da Conferência
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param48" data-target="#collapse-param48" data-toggle="collapse">
                          <label for="habilitaPesquisaConferencia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param46">
                              46. Solicitar senha de supervisor ao cancelar uma venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param48" class="collapse" aria-labelledby="param48" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Solicitar senha de supervisor ao cancelar uma venda
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="1">Não</option> <!-- value invertido pois o parametro foi criado incorretamente, então tive que corrigir. !-->
                                <option value="0">Sim - Supervisor/Master</option>
                                <option value="2">Sim - Master</option>
                                <option value="3">Sim - Supervisor/Master somente para Vendas Fechadas e Devoluções</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param49" data-target="#collapse-param49" data-toggle="collapse">
                          <label for="habilitaPesquisaConferencia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param49">
                              47. Utiliza Barra Log
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param49" class="collapse" aria-labelledby="param49" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a empresa utiliza Barra Log na venda
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Sim - Controla barra lida</option>
                                <option value="3">Sim - Somente BarraLog</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param50" data-target="#collapse-param50" data-toggle="collapse">
                          <label for="nfe_operacao_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param50">
                              48. Operação padrão para NF-e (venda)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param50" class="collapse" aria-labelledby="param50" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Operação padrão para já trazer preenchido ao gerar uma NF-e na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtOperacaoNFe">Operação</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtOperacaoNFe" name="txtOPeracaoNFe" class="form-control" placeholder="Operação">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-OperacaoNFe" name="btn-OperacaoNFCE" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-OperacaoNFe" name="btn-limpa-OperacaoNFe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param51" data-target="#collapse-param51" data-toggle="collapse">
                          <label for="mostraCreditoVenda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param51">
                              49. Mostrar crédito na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param51" class="collapse" aria-labelledby="param51" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai mostrar todo o crédito do cliente na aba dos itens, ou apenas da última devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Todo o crédito</option>
                                <option value="1">Apenas da última devolução</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param52" data-target="#collapse-param52" data-toggle="collapse">
                          <label for="permiteSelecionarAntecipacoes">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param52">
                              50. Permite selecionar antecipações
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param52" class="collapse" aria-labelledby="param52" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o usuário poderá selecionar as antecipações ou usa conforme a ordem de emissão.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Usa antecipações conforme ordem de emissão</option>
                                <option value="1">Seleciona Antecipações - Não permitindo utilizar vencidas</option>
                                <option value="2">Seleciona Antecipações - Permitindo utilizar vencidas</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param53" data-target="#collapse-param53" data-toggle="collapse">
                          <label for="gerarAntecipacaoFrete">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param53">
                              51. Gerar Antecipação com valor de frete na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param53" class="collapse" aria-labelledby="param53" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai gerar uma antecipação do contas a receber com o valor de frete na finalização da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#collapse-param-venda-51" data-toggle="collapse">
                          <label for="clientePorEmpresa">
                            <span class="primary-color-dark semi-bold">
                              52. Cliente por Empresa
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param-venda-51" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se empresa irá utilizar cliente separado por empresa na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param56" data-target="#collapse-param56" data-toggle="collapse">
                          <label for="duplicata_cliente">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param56">
                              53. Gerar duplicata em nome do cliente
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param56" class="collapse" aria-labelledby="param56" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai gerar duplicata em nome do cliente quando for cartão de crédito na finalização da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param58" data-target="#collapse-param58" data-toggle="collapse">
                          <label for="nfe_operacao_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param58">
                              54. Operação padrão para NF-e (devolução)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param58" class="collapse" aria-labelledby="param58" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Operação padrão para já trazer preenchido ao gerar uma NF-e na devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtOperacaoNFeDev">Operação</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtOperacaoNFeDev" name="txtOPeracaoNFeDev" class="form-control" placeholder="Operação">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-OperacaoNFeDev" name="btn-OperacaoNFCE" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-OperacaoNFeDev" name="btn-limpa-OperacaoNFeDev" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param59" data-target="#collapse-param59" data-toggle="collapse">
                          <label for="habilitaPesquisaConferencia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param59">
                              55. Usuário pode consultar outros caixas
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param59" class="collapse" aria-labelledby="param59" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o usuário pode pesquisar a venda de outros caixas
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Apenas caixas vinculados ao usuário</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param60" data-target="#collapse-param60" data-toggle="collapse">
                          <label for="bloqueiaDevolucaoSemNFE">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param60">
                              56. Bloquear devolução sem NF-e
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param60" class="collapse" aria-labelledby="param60" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá bloquear gravar devolução sem NF-e
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param61" data-target="#collapse-param61" data-toggle="collapse">
                          <label for="paramVenda57">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param60">
                              57. Utiliza número de venda sequencial por dia
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param61" class="collapse" aria-labelledby="param61" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá mostrar um número de venda sequencial reiniciado todos os dias
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param62" data-target="#collapse-param62" data-toggle="collapse">
                          <label for="nfce_operacao_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param62">
                              58. Operação padrão para NFC-e (venda)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param62" class="collapse" aria-labelledby="param62" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Operação padrão para já trazer preenchido ao gerar uma NFC-e na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtOperacaoNFCe">Operação</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtOperacaoNFCe" name="txtOPeracaoNFCe" class="form-control" placeholder="Operação">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-OperacaoNFCe" name="btn-OperacaoNFCE" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-OperacaoNFCe" name="btn-limpa-OperacaoNFCe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param63" data-target="#collapse-param63" data-toggle="collapse">
                          <label for="antecipacao_devolucao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param63">
                              59. Gerar antecipação ao efetuar devolução
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param63" class="collapse" aria-labelledby="param63" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o sistema deve gerar antecipação ao efetuar uma devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Fazer pergunta ao usuário</option>
                                <option value="3">Sim - Gerar como tipo devolução</option>
                                <option value="4">Sim - Ao utilizar na venda irá lançar como desconto</option>
                                <option value="5">Sim - Gerar como tipo devolução e mostrar totais na tela (necessário esta posição para funcionar o parâmetro 20 do Faturamento)</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param64" data-target="#collapse-param64" data-toggle="collapse">
                          <label for="vendedor_padrao_agrup">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param64">
                              60. Vendedor padrão para vendas agrupadas
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param64" class="collapse" aria-labelledby="param64" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Vendedor padrão para já trazer preenchido ao agrupar vendas.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtVendedorAgrup">Vendedor</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtVendedorAgrup" name="txtVendedorAgrup" class="form-control" placeholder="Vendedor">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-vendedorAgrup" name="btn-vendedorAgrup" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-vendedorAgrup" name="btn-limpa-vendedorAgrup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param64" data-target="#collapse-param65" data-toggle="collapse">
                          <label for="vendedor_padrao_agrup">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param65">
                              61. Utiliza EPC na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param65" class="collapse" aria-labelledby="param65" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Usa integração EPC na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Itag Monitor</option>
                                <option value="2">Contare</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param66" data-target="#collapse-param66" data-toggle="collapse">
                          <label for="vendedor_padrao_agrup">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param66">
                              62. Agrupamento de Itens
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param66" class="collapse" aria-labelledby="param66" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se ao registrar um novo item no loja e o mesmo já existir na lista de itens deve ser agrupado ou não.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param68" data-target="#collapse-param68" data-toggle="collapse">
                          <label for="antecipacao_outras_empresas">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param68">
                              63. Antecipações outras empresas
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param68" class="collapse" aria-labelledby="param68" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se poderá consultar antecipações de outras empresas.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#devolucao_sem_desconto_moeda" data-toggle="collapse">
                          <label for="paramVenda64">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param68">
                              64. Considerar desconto nas formas de pagamento, ao buscar o preço do item na devolução.
                            </span>
                          </label>
                        </div>
                        <div id="devolucao_sem_desconto_moeda" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o sistema deve considerar o desconto dado nas formas de pagamento da venda referenciada, para definir o preço do item que está sendo devolvido.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não considerar</option>
                                <option value="1">Considerar</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#caixa_cego" data-toggle="collapse">
                          <label for="paramVenda65">
                            <span class="primary-color-dark semi-bold">
                              65. Utiliza caixa cego para fechamento do caixa.
                            </span>
                          </label>
                        </div>
                        <div id="caixa_cego" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é utilizado o processo de caixa cego para fechamento do caixa.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#consumidorFinalVenda" data-toggle="collapse">
                          <label for="paramVenda66">
                            <span class="primary-color-dark semi-bold">
                              66. Cliente pessoa física e consumidor final.
                            </span>
                          </label>
                        </div>
                        <div id="consumidorFinalVenda" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a venda será feita somente com cliente do tipo pessoa física e selecionado como consumidor final, ou entidades do tipo Cliente.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Tipo Cliente</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#senhaSupervisorCaixa" aria-controls="collapse-param70" data-toggle="collapse">
                          <label for="paramVenda67">
                            <span class="primary-color-dark semi-bold">
                              67. Solicitar senha de supervisor ao entrar na tela de fechamento de caixa
                            </span>
                          </label>
                        </div>
                        <div id="senhaSupervisorCaixa" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text" aria-controls="collapse-param70">
                                  Define se a senha de supervisor será solicitada ao entrar na tela de fechamento de caixa
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param71" data-target="#collapse-param71" data-toggle="collapse">
                          <label for="cfe_operacao_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param71">
                              68. Operação padrão para CF-e (venda)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param71" class="collapse" aria-labelledby="param71" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Operação padrão para já trazer preenchido ao gerar uma CF-e na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtOperacaoCFe">Operação</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtOperacaoCFe" name="txtOPeracaoCFe" class="form-control" placeholder="Operação">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-OperacaoCFe" name="btn-OperacaoCFe" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-OperacaoCFe" name="btn-limpa-OperacaoCFe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#integracaoIshopp" aria-controls="collapse-param72" data-toggle="collapse">
                          <label for="paramVenda69">
                            <span class="primary-color-dark semi-bold">
                              69. Integração iShopp (iBASi)
                            </span>
                          </label>
                        </div>
                        <div id="integracaoIshopp" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text" aria-controls="collapse-param72">
                                  Define se contém integração com sistema iShopp (iBASi)
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Sim (Apenas as vendas com guia)</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#integracaoNetShopping" aria-controls="collapse-param73" data-toggle="collapse">
                          <label for="paramVenda70">
                            <span class="primary-color-dark semi-bold">
                              70. Integração NetShopping
                            </span>
                          </label>
                        </div>
                        <div id="integracaoNetShopping" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text" aria-controls="collapse-param73">
                                  Define se contém integração com sistema NetShopping
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#integracaoTeiaCard" aria-controls="collapse-param75" data-toggle="collapse">
                          <label for="paramVenda71">
                            <span class="primary-color-dark semi-bold">
                              71. Integração TeiaCard
                            </span>
                          </label>
                        </div>
                        <div id="integracaoTeiaCard" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text" aria-controls="collapse-param75">
                                  Define se contém integração com sistema TeiaCard
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#tipoVendaPadrao" aria-controls="collapse-param76" data-toggle="collapse">
                          <label for="paramVenda72">
                            <span class="primary-color-dark semi-bold">
                              72. Tipo venda padrão
                            </span>
                          </label>
                        </div>
                        <div id="tipoVendaPadrao" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <label data-error="wrong" data-success="right" for="txtTipoVendaPadrao">Tipo venda padrão ao iniciar uma venda</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtTipoVendaPadrao" name="txtTipoVendaPadrao" class="form-control" placeholder="Tipo Venda Padrão">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-TipoVendaPadrao" name="btn-TipoVendaPadrao" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-TipoVendaPadrao" name="btn-limpa-TipoVendaPadrao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#utiliza_cashback" data-toggle="collapse">
                          <label for="paramVenda73">
                            <span class="primary-color-dark semi-bold">
                              73. Utiliza Cashback
                            </span>
                          </label>
                        </div>
                        <div id="utiliza_cashback" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a empresa utiliza sistema de cashback para atribuir descontos ao cliente.
                                </span>
                                <br>OBS: É necessário configurar os valores padrões para definir algumas configurações necessárias.
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim - Padrão Sisplan</option>
                                <option value="2">Sim - CRM&Bônus</option>
                                <option value="3">Sim - Padrão Sisplan (Considerando regra promocional)</option>
                                <option value="4">Sim - Padrão Sisplan (Exceto quando possuir desconto na venda)</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#devolucaoConsignado" data-toggle="collapse">
                          <label for="paramVenda74">
                            <span class="primary-color-dark semi-bold">
                              74. Devolução de Consignado
                            </span>
                          </label>
                        </div>
                        <div id="devolucaoConsignado" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá permitir fazer devolução de consignado na tela de agrupamento de venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Liberado</option>
                                <option value="1">Dar mensagem e solicitar senha de supervisor</option>
                                <option value="2">Dar mensagem e bloqueia</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#tipoBalanca" data-toggle="collapse">
                          <label for="paramVenda75">
                            <span class="primary-color-dark semi-bold">
                              75. Utiliza balança ACBr
                            </span>
                          </label>
                        </div>
                        <div id="tipoBalanca" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá utilizar balança ACBr.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Balança Padrão</option>
                                <option value="1">Balança ACBr</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#bloqueiaVendaItemSemTabPreco" data-toggle="collapse">
                          <label for="paramVenda76">
                            <span class="primary-color-dark semi-bold">
                              76. Bloqueia venda com item sem cadastro na tabela de preço
                            </span>
                          </label>
                        </div>
                        <div id="bloqueiaVendaItemSemTabPreco" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se bloqueia adicionar um item sem cadastro na tabela de preço.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#bloqueiaVendaPendenteMesmoCliente" data-toggle="collapse">
                          <label for="paramVenda77">
                            <span class="primary-color-dark semi-bold">
                              77. Bloqueia venda caso houver consignado/venda pendente para o cliente
                            </span>
                          </label>
                        </div>
                        <div id="bloqueiaVendaPendenteMesmoCliente" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Bloqueia criar nova venda para um cliente que já contém consignado pendente.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#validaVendaEstoqueRegiaoVendedor" data-toggle="collapse">
                          <label for="paramVenda78">
                            <span class="primary-color-dark semi-bold">
                              78. Validar venda e estoque por região do vendedor
                            </span>
                          </label>
                        </div>
                        <div id="validaVendaEstoqueRegiaoVendedor" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Bloqueia na venda os campos Vendedor, buscando o vendedor vinculado ao usuário, Depósito irá buscar do último movimento vinculado ao vendedor.
                                  Cliente irá buscar os clientes vinculados a regiao do último movimento.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#senhaSupervisorDesconto" data-toggle="collapse">
                          <label for="paramVenda79">
                            <span class="primary-color-dark semi-bold">
                              79. Senha de supervisor ao ultrapassar o limite de desconto na venda.
                            </span>
                          </label>
                        </div>
                        <div id="senhaSupervisorDesconto" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Solicita senha de supervisor ao ultrapassar o limite de desconto da moeda na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#ocultaCupomTroca" data-toggle="collapse">
                          <label for="paramVenda80">
                            <span class="primary-color-dark semi-bold">
                              80. Oculta a opção do Cupom de Troca
                            </span>
                          </label>
                        </div>
                        <div id="ocultaCupomTroca" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a opção do Cupom de Troca ficará oculta.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#bloqueiaAbasInfosEItensVenda" data-toggle="collapse">
                          <label for="paramVenda81">
                            <span class="primary-color-dark semi-bold">
                              81. Bloqueia informações e itens da venda ao finalizar um consignado
                            </span>
                          </label>
                        </div>
                        <div id="bloqueiaAbasInfosEItensVenda" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Ao finalizar o consignado, ocorrerão os seguintes eventos:
                                  <br>
                                  - Ao abrir a tela de venda, será direcionado diretamente para a aba de pagamentos.
                                  <br>
                                  - As abas informações e itens da venda serão bloqueadas.
                                  <br>
                                  - O tipo da "nova venda" ficará como consignado.
                                  <br>
                                  - Mantém o cliente da última venda, até que seja feito a finalização do atendimento.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#descontoMaxTabPrecoVenda" data-toggle="collapse">
                          <label for="paramVenda82">
                            <span class="primary-color-dark semi-bold">
                              82. Aplica desconto max. da tabela de preço na venda
                            </span>
                          </label>
                        </div>
                        <div id="descontoMaxTabPrecoVenda" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define como será aplicado o desconto máximo da tabela de preço na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim - Liberado para alterar manual</option>
                                <option value="2">Sim - Bloqueado para alterar manual</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#bloqueiaEstornoCaixa" data-toggle="collapse">
                          <label for="paramVenda83">
                            <span class="primary-color-dark semi-bold">
                              83. Bloqueia estorno dos lançamentos manuais do caixa
                            </span>
                          </label>
                        </div>
                        <div id="bloqueiaEstornoCaixa" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá bloquear o estorno dos lançamentos manuais feitos no caixa.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim - Bloqueado</option>
                                <option value="2">Sim - Senha supervisor</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#fechamentoCaixaDataHora" data-toggle="collapse">
                          <label for="paramVenda84">
                            <span class="primary-color-dark semi-bold">
                              84. Fechamento de caixa por data/hora
                            </span>
                          </label>
                        </div>
                        <div id="fechamentoCaixaDataHora" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Irá permitir fazer mais de um fechamento de caixa no mesmo dia.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#alteraEnderecoNfce" data-toggle="collapse">
                          <label for="paramVenda85">
                            <span class="primary-color-dark semi-bold">
                              85. Endereço da empresa ao gerar NFC-e para cliente de outro estado
                            </span>
                          </label>
                        </div>
                        <div id="alteraEnderecoNfce" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Ao gerar uma NFC-e para cliente de outro estado, altera o endereço do cliente para o endereço da empresa.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#abreModalInformacoes" data-toggle="collapse">
                          <label for="paramVenda86">
                            <span class="primary-color-dark semi-bold">
                              86. Ao sair do campo cliente, visualizar as informações do cliente
                            </span>
                          </label>
                        </div>
                        <div id="abreModalInformacoes" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se ao sair do campo cliente irá ou não abrir as informações do cliente.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#vendaCaixaAberto" data-toggle="collapse">
                          <label for="paramVenda87">
                            <span class="primary-color-dark semi-bold">
                              87. Bloqueia realizar venda com caixa de dias anteriores em aberto
                            </span>
                          </label>
                        </div>
                        <div id="vendaCaixaAberto" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se deve bloquear a realização de uma venda caso tenha caixa de dias anteriores em aberto.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#descontaReserva" data-toggle="collapse">
                          <label for="paramVenda88">
                            <span class="primary-color-dark semi-bold">
                              88. Quando bipar um item na venda descontar reserva ao validar o estoque
                            </span>
                          </label>
                        </div>
                        <div id="descontaReserva" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se deve descontar reserva na validação de estoque (tabela PED_RESERVA).
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#lancaPagarSaidaManualContagemCaixa" data-toggle="collapse">
                          <label for="paramVenda89">
                            <span class="primary-color-dark semi-bold">
                              89. Gerar financeiro ao fazer um lançamento manual no fechamento de caixa
                            </span>
                          </label>
                        </div>
                        <div id="lancaPagarSaidaManualContagemCaixa" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá lançar pagar baixado e conta corrente do valor de saída manual.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim (Apenas na tela Contagem de Caixa)</option>
                                <option value="2">Sim (Apenas na tela Fechamento de Caixa)</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#senhaAgendamentoGuia" data-toggle="collapse">
                          <label for="paramVenda89">
                            <span class="primary-color-dark semi-bold">
                              90. Controla venda e devolução conforme senha do cadastro de agendamento guia
                            </span>
                          </label>
                        </div>
                        <div id="senhaAgendamentoGuia" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Habilita na venda e devolução o campo senha, que será utilizado para buscar o vendedor e guia do agendamento.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#confirmaImpressaoNFCE" data-toggle="collapse">
                          <label for="paramVenda90">
                            <span class="primary-color-dark semi-bold">
                              91. Reimpressão de NFC-e na venda
                            </span>
                          </label>
                        </div>
                        <div id="confirmaImpressaoNFCE" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se ao finalizar uma venda com NFC-e, irá solicitar uma mensagem de confirmação se a impressão ocorreu, caso for informado não, será feito uma nova tentativa de impressão.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#permiteDevolucaoBarraLogOutraLoja" data-toggle="collapse">
                          <label for="paramVenda90">
                            <span class="primary-color-dark semi-bold">
                              92. Permite devolução com barra_log de outra loja
                            </span>
                          </label>
                        </div>
                        <div id="permiteDevolucaoBarraLogOutraLoja" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se na tela de devolução é possível bipar uma barra_log de outra loja.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#permiteNotaAgrupamentoConsignado" data-toggle="collapse">
                          <label for="paramVenda93">
                            <span class="primary-color-dark semi-bold">
                              93. Emite nota de devolução ao conferir consignado.
                            </span>
                          </label>
                        </div>
                        <div id="permiteNotaAgrupamentoConsignado" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se na tela de agrupamento de consignado será emitido nota de devolução ao conferir.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#devolucaoCashBack" data-toggle="collapse">
                          <label for="paramVenda94">
                            <span class="primary-color-dark semi-bold">
                              94. Valor de cashback na devolução.
                            </span>
                          </label>
                        </div>
                        <div id="devolucaoCashBack" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define o que será feito com o valor de cashback na devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Gera Antecipação</option>
                                <option value="1">Estorna valor cashback</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#depositoEcommerce" data-toggle="collapse">
                          <label for="paramVenda95">
                            <span class="primary-color-dark semi-bold">
                              95. Depósito e-commerce.
                            </span>
                          </label>
                        </div>
                        <div id="depositoEcommerce" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define o depósito do e-commerce na venda, na pesquisa de produto da venda irá flegar o checkbox "Depósito e-commerce", consultando os itens do depósito.
                                  Os itens da venda deste depósito irá gerar um pedido e uma antecipação.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtDepositoEcommerce">Depósito</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtDepositoEcommerce" name="txtDepositoEcommerce" class="form-control" placeholder="Depósito">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-depositoEcommerce" name="btn-depositoEcommerce" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-depositoEcommerce" name="btn-limpa-depositoEcommerce" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#validaTodasEmpDupAtraso" data-toggle="collapse">
                          <label for="paramVenda93">
                            <span class="primary-color-dark semi-bold">
                              96. Buscar duplicatas em atraso de todas as empresas.
                            </span>
                          </label>
                        </div>
                        <div id="validaTodasEmpDupAtraso" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Valida o parâmetro 24 da Venda PDV buscando todas as empresas.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#validaCredHistDupAtraso" data-toggle="collapse">
                          <label for="paramVenda93">
                            <span class="primary-color-dark semi-bold">
                              97. Buscar duplicatas em atraso validando crédito do histórico.
                            </span>
                          </label>
                        </div>
                        <div id="validaCredHistDupAtraso" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Valida o parâmetro 24 da Venda PDV buscando somente duplicatas com crédito marcado no cadastro de histórico.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#comissaoVendTabPreco" data-toggle="collapse">
                          <label for="paramVenda98">
                            <span class="primary-color-dark semi-bold">
                              98. Gerar Comissão.
                            </span>
                          </label>
                        </div>
                        <div id="comissaoVendTabPreco" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Gera comissão para o vendedor com o percentual informado na tabela de preço.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Considerando tabela de preço e representante/vendedor</option>
                                <option value="2">Considerando variação de desconto por item</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda99" data-target="#collapse-paramvenda99" data-toggle="collapse">
                          <label for="solicitaSenhaCancelarCFe">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda99">
                              99. Solicitar senha de supervisor para cancelar CFe.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda99" class="collapse" aria-labelledby="paramvenda99" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Solicita senha de supervisor para cancelar CFe.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="solicitaSenhaCancelarCFe" name="solicitaSenhaCancelarCFe">
                                <option value="0">Não</option>
                                <option value="1">Supervisor/Master</option>
                                <option value="2">Master</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda100" data-target="#collapse-paramvenda100" data-toggle="collapse">
                          <label for="bloquearFinalizacaoVendaDesdobramento">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda100">
                              100. Bloquear finalização da venda caso tenha material que necessite Desdobramento e não tenha sido feito.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda100" class="collapse" aria-labelledby="paramvenda100" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Bloquear finalização da venda que tenha algum material que necessite ser desdobrado (cadastro do grupo marcado como Permite Desdobramento Venda e quantidade original diferente da quantidade que está sendo vendida)
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="bloquearFinalizacaoVendaDesdobramento" name="bloquearFinalizacaoVendaDesdobramento">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda100" data-target="#collapse-paramvenda101" data-toggle="collapse">
                          <label for="enviarRomaneioDaVendaWhatsapp">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda101">
                              101. Enviar romaneio da venda pelo Whatsapp ao finalizar a venda.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda101" class="collapse" aria-labelledby="paramvenda101" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Envia o romaneio da venda pelo Whatsapp ao finalizar a venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="enviarRomaneioDaVendaWhatsapp" name="enviarRomaneioDaVendaWhatsapp">
                                <option value="0">Enviar</option>
                                <option value="1">Não enviar</option>
                                <option value="2">Não enviar romaneio e não enviar mensagem</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda102" data-target="#collapse-paramvenda102" data-toggle="collapse">
                          <label for="validaCpfNfce">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda102">
                              102. Bloquear emissão de NFC-e para CPF/CNPJ inválido quando a venda exceder o valor definido.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda102" class="collapse" aria-labelledby="paramvenda102" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Irá validar se o CPF/CNPJ é válido quando o valor da venda exceder o valor definido nos valores padrões (aba Loja/Venda, subaba Venda, campo VALOR_MAX_NFCE).
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="validaCpfNfce" name="validaCpfNfce">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda103" data-target="#collapse-paramvenda103" data-toggle="collapse">
                          <label for="valorIPIVenda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda103">
                              103. Valor de IPI na venda.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda103" class="collapse" aria-labelledby="paramvenda103" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá calcular o valor de IPI na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="valorIPIVenda" name="valorIPIVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda104" data-target="#collapse-paramvenda104" data-toggle="collapse">
                          <label for="validarDepositoBarralogVenda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda104">
                              104. Validar depósito da barra_log na Venda.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda104" class="collapse" aria-labelledby="paramvenda104" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá validar o depósito da barra_log na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="validarDepositoBarralogVenda" name="validarDepositoBarralogVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda105" data-target="#collapse-paramvenda105" data-toggle="collapse">
                          <label for="ocultarGravarBrinde">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda105">
                              105. Ocultar botão gravar brinde.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda105" class="collapse" aria-labelledby="paramvenda105" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá ocultar o botão de gravar brinde.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="ocultarGravarBrinde" name="ocultarGravarBrinde">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda106" data-target="#collapse-paramvenda106" data-toggle="collapse">
                          <label for="ocultarGravarBrinde">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda106">
                              106. Valor de retenção IVA.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda106" class="collapse" aria-labelledby="paramvenda106" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá calcular o valor de retenção do IVA na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="ocultarGravarBrinde" name="ocultarGravarBrinde">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda106" data-target="#collapse-paramvenda107" data-toggle="collapse">
                          <label for="collapse-paramvenda107">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda107">
                              107. Quantidade Máxima de Itens da Venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda107" class="collapse" aria-labelledby="paramvenda107" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define a quantidade máxima de itens que podem ser inseridos na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-3">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtQuantidadeMaximaItens">Quantidade Máxima Itens</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtQuantidadeMaximaItens" name="txtQuantidadeMaximaItens" class="form-control" placeholder="Qtde Máxima Itens">
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda108" data-target="#collapse-paramvenda108" data-toggle="collapse">
                          <label for="bloqMaisDocFiscal">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda108">
                              108. Bloquear gerar mais de um documento fiscal igual por venda.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda108" class="collapse" aria-labelledby="paramvenda108" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Quando ativo, não permite gerar mais de um documento fiscal igual (ex: 2 NFC-e's ou 2 NF-e's) por venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="bloqMaisDocFiscal" name="bloqMaisDocFiscal">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Sim - Validando operação</option>
                                <option value="3">Sim - Permite apenas uma NF-e ou uma NFC-e</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda108" data-target="#collapse-paramvenda109" data-toggle="collapse">
                          <label for="bloqMaisDocFiscal">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda109">
                              109. Considerar no saldo de Crédito Grupo a soma de Pedido pendentes.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda109" class="collapse" aria-labelledby="paramvenda109" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Quando ativo, irá considerar no saldo de crédito do Grupo a soma de Pedidos Pendentes.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="somarPedidoPendenteCreditoGrupo" name="somarPedidoPendenteCreditoGrupo">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramvenda108" data-target="#collapse-paramvenda110" data-toggle="collapse">
                          <label for="bloqMaisDocFiscal">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramvenda110">
                              110. Gerar lançamento de comissões mesmo com FAT e REC zeradas.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramvenda110" class="collapse" aria-labelledby="paramvenda110" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Lança REC_COM zeradas quando FAT e REC estiverem zeradas.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="permiteGerarComissaoZerada" name="permiteGerarComissaoZerada">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-receber" role="tabpanel" aria-labelledby="v-pills-receber-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param27" data-target="#collapse-param27" data-toggle="collapse">
                        <label for="lanca_baixa_caixa_receber">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param27">
                            01. Lançar baixa do receber no caixa
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param27" class="collapse" aria-labelledby="param27" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Traz marcado o campo 'Lançar no caixa' por padrão ao realizar uma baixa.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="lanca_baixa_caixa_receber" name="lanca_baixa_caixa_receber">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param28" data-target="#collapse-param28" data-toggle="collapse">
                        <label for="cupom_gerencial_receber">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param28">
                            02. Impressão de relatório gerencial ao baixar duplicata
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param28" class="collapse" aria-labelledby="param28" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se deve ser impresso um relatório gerencial ao baixar uma duplicata.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="cupom_gerencial_receber" name="cupom_gerencial_receber">
                              <option value="0">Não</option>
                              <option value="1">Sim - 1 via</option>
                              <option value="2">Sim - 2 vias</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param29" data-target="#collapse-param29" data-toggle="collapse">
                        <label for="BuscaAntecipacao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param29">
                            03. Busca antecipações da empresa demo na venda
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param29" class="collapse" aria-labelledby="param29" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Busca antecipações da empresa demo na venda
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="BuscaAntecipacao" name="BuscaAntecipacao">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param30" data-target="#collapse-param30" data-toggle="collapse">
                        <label for="GeraCaixaCheque">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param30">
                            04. Ao cadastrar cheque lançar no caixa do loja
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param30" class="collapse" aria-labelledby="param30" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Ao cadastrar cheque irá fazer a pergunta se deseja lançar no caixa do loja.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="GeraCaixaCheque" name="GeraCaixaCheque">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="card-header" id="paramRec4" data-target="#collapse-paramRec4" data-toggle="collapse">
                        <label for="valida_credito_cliente">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec4">
                            05. Ao cadastrar cheque validar crédito de cliente.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec4" class="collapse" aria-labelledby="paramRec4" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá validar limite de crédito disponível para o cliente.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="valida_credito_cliente" name="valida_credito_cliente">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="card-header" id="paramRec5" data-target="#collapse-paramRec5" data-toggle="collapse">
                        <label for="valida_credito_grupo">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec5">
                            06. Ao cadastrar cheque validar crédito de grupo.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec5" class="collapse" aria-labelledby="paramRec5" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá validar limite de crédito disponível para o grupo.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="valida_credito_grupo" name="valida_credito_grupo">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec6" data-target="#collapse-paramRec6" data-toggle="collapse">
                        <label for="bloqueia_conta_corrente">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec6">
                            07. Não permite baixar receber sem lançar no conta corrente.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec6" class="collapse" aria-labelledby="paramRec6" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se o flag será bloqueado ou liberado.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="bloqueia_conta_corrente" name="bloqueia_conta_corrente">
                              <option value="0">Selecione uma opção</option>
                              <option value="1">B - Marcado e Bloqueado (não pode desmarcar)</option>
                              <option value="2">L - Marcado e Liberado (pode desmarcar)</option>
                              <option value="3">D - Desmarcado e Bloqueado (não pode desmarcar)</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec6" data-target="#collapse-paramRec7" data-toggle="collapse">
                        <label for="bloqueia_conta_corrente">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec6">
                            08. Bloqueia campos conta, classe e histórico ao informar moeda na baixa do receber.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec7" class="collapse" aria-labelledby="paramRec7" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se os campos serão bloqueados.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="bloqueia_campos_baixa_receber" name="bloqueia_campos_baixa_receber">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec9" data-target="#collapse-paramRec9" data-toggle="collapse">
                        <label for="bloqueia_conta_corrente">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec9">
                            09. Bloqueia dar desconto manual (% ou valor) na baixa do receber.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec9" class="collapse" aria-labelledby="paramRec9" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se os campos serão bloqueados.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="bloqueia_desconto_baixa_receber" name="bloqueia_desconto_baixa_receber">
                              <option value="0">Liberado</option>
                              <option value="1">Bloqueado</option>
                              <option value="2">Liberado - Solicita senha de supervisor</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec10" data-target="#collapse-paramRec10" data-toggle="collapse">
                        <label for="busca_desconto_auto">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec10">
                            10. Busca desconto automático do cadastro de moeda na baixa do receber.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec10" class="collapse" aria-labelledby="paramRec10" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Irá sugerir o desconto informado no cadastro de moeda, campo "% Desconto automático".
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="buscaDescAutoMoeda" name="buscaDescAutoMoeda">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec11" data-target="#collapse-paramRec11" data-toggle="collapse">
                        <label for="habilita_empresa_receber_pagar">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec11">
                            11. Permite lançar receber ou pagar em empresas diferentes da logada.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec11" class="collapse" aria-labelledby="paramRec11" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Habilita campo "Empresa" ao incluir receber ou pagar.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="habilita_empresa_receber_pagar" name="buscaDescAutoMoeda">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec12" data-target="#collapse-paramRec12" data-toggle="collapse">
                        <label for="lanca_comissao_representante_duplicata">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec12">
                            12. Ao realizar o fechamento de comissão, lançar por representante ou duplicata.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec12" class="collapse" aria-labelledby="paramRec12" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se a comissão será lançada por representante ou duplicata.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="lanca_comissao_representante_duplicata">
                              <option value="0">Não lançar no pagar</option>
                              <option value="1">Representante</option>
                              <option value="2">Duplicata</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec13" data-target="#collapse-paramRec13" data-toggle="collapse">
                        <label for="lanca_comissao_frete_receber">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec13">
                            13. Ao realizar o lançamento de comissão, descontar o valor de frete.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec13" class="collapse" aria-labelledby="paramRec13" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá descontar o valor de frete ao lançar comissão.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="lanca_comissao_frete_receber">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec14" data-target="#collapse-paramRec14" data-toggle="collapse">
                        <label for="lanca_comissao_frete_receber">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec14">
                            14. Obriga informar o pedido no cadastro de cheque/desdobramento de antecipação.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec14" class="collapse" aria-labelledby="paramRec14" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá obrigar informar pedido nas telas de cadastro de cheque e no desdobramento de antecipação.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="lanca_comissao_frete_receber">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec15" data-target="#collapse-paramRec15" data-toggle="collapse">
                        <label for="validacaoContaContabilEntidade">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec15">
                            15. Validação conta contábil ao cadastrar uma entidade.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec15" class="collapse" aria-labelledby="paramRec15" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define validação da conta contábil ao cadastrar uma entidade.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="validacaoContaContabilEntidade">
                              <option value="N">Não faz validações</option>
                              <option value="S">Busca do cadastro da tabela padrão e concatena com o codcli para gerar uma nova conta de cliente</option>
                              <option value="M">Da uma mensagem avisando que o usuário não preencheu o campo, porém permite continuar</option>
                              <option value="B">Bloqueio se não for preenchido as contas contábeis e não deixa continuar</option>
                              <option value="P">Busca o cadastro dos valores padrões</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec16" data-target="#collapse-paramRec16" data-toggle="collapse">
                        <label for="geraContaCorUnico">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec15">
                            16. Ao confirmar pagamento, gerar conta corrente único para todos as baixas do cartão.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec16" class="collapse" aria-labelledby="paramRec16" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Ao confirmar pagamento, gerar conta corrente único para todos as baixas do cartão. Isto serve para que na conciliação, mostre somente um registro.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="geraContaCorUnico">
                              <option value="0">Conta Corrente por Baixa</option>
                              <option value="1">Conta Corrente Unico</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-faturamento" role="tabpanel" aria-labelledby="v-pills-faturamento-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param33" data-target="#collapse-param33" data-toggle="collapse">
                        <label for="calcula_peso_faturamento">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param33">
                            01. Calcular peso dos itens
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param33" class="collapse" aria-labelledby="param33" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Calcula automaticamente o peso bruto e líquido no faturamento.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="calcula_peso_faturamento" name="calcula_peso_faturamento">
                              <option value="0">Não</option>
                              <option value="1">Sim - Cadastro de Produto/Material</option>
                              <option value="2">Sim - Variação E-commerce</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param43" data-target="#collapse-param43" data-toggle="collapse">
                        <label for="faturamento_automatico">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param43">
                            02. Faturamento automático
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param43" class="collapse" aria-labelledby="param43" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Gerar/Imprimir nota automaticamente ao gravar o faturamento.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="faturamento_automatico" name="faturamento_automatico">
                              <option value="0">Não</option>
                              <option value="1">Gerar</option>
                              <option value="2">Gerar e imprimir</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param51" data-target="#collapse-param51" data-toggle="collapse">
                        <label for="certificado_a3">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param51">
                            03. Utiliza certificado A3.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param51" class="collapse" aria-labelledby="param51" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Pede senha para utilizar certificado. (Obs: Quando o parâmetro estiver "Sim" irá buscar os inis de NFE e NFCE do mesmo diretório onde está a ApiLocal.)
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="certificado_a3" name="certificado_a3">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param54" data-target="#collapse-param54" data-toggle="collapse">
                        <label for="indice_fat">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param54">
                            04. Utiliza índice
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param54" class="collapse" aria-labelledby="param54" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Utiliza percentual de índice ao faturar.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="indice_fat" name="indice_fat">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param55" data-target="#collapse-param55" data-toggle="collapse">
                        <label for="fat_val_liq">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param55">
                            05. Desconto faturamento de venda
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param55" class="collapse" aria-labelledby="param55" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define como será utilizado o desconto ao faturar venda.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-4">
                            <select class="input-default parametroFaturamento" id="fat_val_liq" name="fat_val_liq">
                              <option value="0">Ratear desconto entre os itens</option>
                              <option value="1">Trazer itens com valor líquido</option>
                              <option value="2">Trazer desconto unitário</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param73" data-target="#collapse-param73" data-toggle="collapse">
                        <label for="endentregadados_fat">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param73">
                            06. Endereço de Entrega nos Dados Adicionais
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param73" class="collapse" aria-labelledby="param73" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Destaca o endereço de entrega na nota fiscal após o faturamento
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="endentregadados_fat" name="endentregadados_fat">
                              <option value="0">Não destaca</option>
                              <option value="1">Destaca nos dados adicionais</option>
                              <option value="2">Destaca nos dados adicionais somente se o endereço for diferente do endereço de entrega</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param74" data-target="#collapse-param74" data-toggle="collapse">
                        <label for="obspedidodados_fat">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param74">
                            07. Observação do Pedido nos Dados Adicionais
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param74" class="collapse" aria-labelledby="param74" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Adiciona a observação do pedido nos dados adicionais da nota.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="obspedidodados_fat" name="obspedidodados_fat">
                              <option value="0">Não destaca</option>
                              <option value="1">Destaca nos dados adicionais</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param75" data-target="#collapse-param75" data-toggle="collapse">
                        <label for="emailTransmissao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param75">
                            08. Enviar e-mail e/ou WhatsApp após transmitir a nota.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param75" class="collapse" aria-labelledby="param75" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Enviar e-mail e/ou WhatsApp após transmitir a nota.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="emailTransmissao" name="emailTransmissao">
                              <option value="0">Não</option>
                              <option value="1">Sim - E-mail</option>
                              <option value="2">Sim - WhatsApp</option>
                              <option value="3">Sim - E-mail e WhatsApp</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param750" data-target="#collapse-param750" data-toggle="collapse">
                        <label for="solicitaSenhaCancelarNota">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param750">
                            09. Solicitar senha para cancelar nota.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param750" class="collapse" aria-labelledby="param750" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Solicita senha de supervisor/master para cancelar nota após determinado tempo.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="solicitaSenhaCancelarNota" name="solicitaSenhaCancelarNota">
                              <option value="0">Não</option>
                              <option value="5">Sim</option>
                              <option value="6">Sim - Master</option>
                              <option value="1">Supervisor/Master - Após 24 hrs</option>
                              <option value="2">Supervisor/Master - Após 48 hrs</option>
                              <option value="3">Master - Após 24 hrs</option>
                              <option value="4">Master - Após 48 hrs</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param750" data-target="#collapse-param751" data-toggle="collapse">
                        <label for="emailTransportadora">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param751">
                            10. Enviar e-mail à transportadora após transmitir a nota.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param751" class="collapse" aria-labelledby="param751" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Enviar e-mail à transportadora após transmitir a nota.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="emailTransportadora" name="emailTransportadora">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param753" data-target="#collapse-param753" data-toggle="collapse">
                        <label for="tabPrecoFaturamento">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param753">
                            11. Habilita campo tabela de preço.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param753" class="collapse" aria-labelledby="param753" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Torna campo visível e editável para buscar determinada tabela de preço.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="tabPrecoFaturamento" name="tabPrecoFaturamento">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param7531" data-target="#collapse-param7531" data-toggle="collapse">
                        <label for="tabPrecoFaturamento">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param7531">
                            12. Valida cadastro de cotação da moeda.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param7531" class="collapse" aria-labelledby="param7531" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Faz validação se há cotação da moeda selecionada para o dia atual.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="validaCotacaoMoeda" name="validaCotacaoMoeda">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param75313" data-target="#collapse-param75313" data-toggle="collapse">
                        <label for="tabPrecoFaturamento">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param75313">
                            13. Gerar GNRE automático.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param75313" class="collapse" aria-labelledby="param75313" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Gera GNRE após gerar a NF-e automaticamente.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="geraGnreAut" name="geraGnreAut">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param75314" data-target="#collapse-param75314" data-toggle="collapse">
                        <label for="tabBloqNatureza">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param75314">
                            14. Bloquear o campo de natureza, permitindo informar apenas a operação fiscal.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param75314" class="collapse" aria-labelledby="param75314" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Irá bloquear o campo natureza, permitindo informar apenas o campo operação fiscal.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="bloqNatureza" name="bloqNatureza">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param75315" data-target="#collapse-param75315" data-toggle="collapse">
                        <label for="tabAjusteICMS">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param75315">
                            15. Ajustar ICMS antes de emitir a nota.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param75315" class="collapse" aria-labelledby="param75315" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Irá ajustar o ICMS antes da emissão da nota.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="ajusteICMS" name="ajusteICMS">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param75315" data-target="#collapse-param753915" data-toggle="collapse">
                        <label for="tabcalcdifsc">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param753915">
                            16. Cálculos diferenciados para CST's 50, 20, 70, 41, 30, 40, 51.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param753915" class="collapse" aria-labelledby="param753915" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Cálculos diferenciados para CST's 50, 20, 70, 41, 30, 40, 51.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="calcdifsc" name="calcdifsc">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param75315" data-target="#collapse-param1753915" data-toggle="collapse">
                        <label for="tabcalcdifgo">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param1753915">
                            17. Cálculos diferenciados para CST's 10, 20, 70.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param1753915" class="collapse" aria-labelledby="param1753915" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Cálculos diferenciados para CST's 10, 20, 70.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="calcdifgo" name="calcdifgo">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param1753915514" data-target="#collapse-param1753915514" data-toggle="collapse">
                        <label for="tabcalcdifgo">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param1753915514">
                            18. Mensagem de aproveitamento de crédito do Simples Nacional.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param1753915514" class="collapse" aria-labelledby="param1753915514" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Gerar mensagem de aproveitamento de crédito do Simples Nacional nos dados adicionais da nota.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="gerarmsgaproveitamento" name="gerarmsgaproveitamento">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param1753915994" data-target="#collapse-param1753915994" data-toggle="collapse">
                        <label for="tabcalcdifgo">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param1753915994">
                            19. Mensagem de valor aproximado dos tributos.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param1753915994" class="collapse" aria-labelledby="param1753915994" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Gerar mensagem de valor aproximado dos tributos nos dados adicionais da nota.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="gerarmsgvalortributos" name="gerarmsgvalortributos">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param1799915994" data-target="#collapse-param1799915994" data-toggle="collapse">
                        <label for="tabcalcdifgo">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param1799915994">
                            20. Jogar valor de antecipação como desconto.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param1799915994" class="collapse" aria-labelledby="param1799915994" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Jogar valor de antecipação como desconto ao faturar venda.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="jogarvalantecomodesc" name="jogarvalantecomodesc">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param172134" data-target="#collapse-param172134" data-toggle="collapse">
                        <label for="tabcalcdifgo">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param172134">
                            21. Concatenar cor e tamanho (NFC-e).
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param172134" class="collapse" aria-labelledby="param172134" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Concatenar cor e tamanho na descrição da NFC-e.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="concatcortam" name="concatcortam">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param1721394" data-target="#collapse-param1721394" data-toggle="collapse">
                        <label for="tabcalcdifgo">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param1721394">
                            22. Buscar devolução da nota de entrada.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param1721394" class="collapse" aria-labelledby="param1721394" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Para funcionar deve ser marcado o flag 'Saída Devolução' do tipo de baixa vinculado a operação fiscal. Com isso, referenciará a nota devolvida automaticamente e também buscará o preço da mesma.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="buscanovadevol" name="buscanovadevol">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param17291394" data-target="#collapse-param17291394" data-toggle="collapse">
                        <label for="tabcalcdifgo">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param17291394">
                            23. Permite alterar condições de pagamento do pedido.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param17291394" class="collapse" aria-labelledby="param17291394" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Quando ativo, deixa fazer alterações no pagamento mesmo qua haja COND_PAGTO.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="alteracondpagtofat" name="alteracondpagtofat">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-produto" role="tabpanel" aria-labelledby="v-pills-produto-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param201" data-target="#collapse-param201" data-toggle="collapse">
                        <label for="calcula_peso_produto">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param201">
                            01. Atualiza preço ao gravar produto
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param201" class="collapse" aria-labelledby="param201" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Atualiza o preço do produto na tabela de preço padrão ao gravar (inclusão ou alteração).
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroProduto" id="calcula_peso_produto" name="calcula_peso_produto">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param205" data-target="#collapse-param205" data-toggle="collapse">
                        <label for="atualiza_custo_produto">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param205">
                            02. Atualiza custo com o preço médio
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param205" class="collapse" aria-labelledby="param205" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Atualiza o custo do estoque com o preço médio nas movimentações de estoque.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroProduto" id="atualiza_custo_produto" name="atualiza_custo_produto">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param211" data-target="#collapse-param211" data-toggle="collapse">
                        <label for="atualiza_custo_produto">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param211">
                            03. Gerar código da cor com o grupo/subgrupo
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param211" class="collapse" aria-labelledby="param211" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Gerar código da cor utilizando código do grupo ou do subgrupo.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroProduto" id="atualiza_custo_produto" name="atualiza_custo_produto">
                              <option value="0">Não</option>
                              <option value="1">Sim - Utilizando apenas com Grupo</option>
                              <option value="2">Sim - Utilizando Grupo e SubGrupo</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param212" data-target="#collapse-param212" data-toggle="collapse">
                        <label for="bloqueia_precoSped_produto">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param212">
                            04. Bloquear digitação do campo Preço Sped na Entrada Manual
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param212" class="collapse" aria-labelledby="param212" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Bloquear digitação do campo Preço Sped ao dar Entrada Manual.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroProduto" id="bloqueia_precoSped_produto" name="bloqueia_precoSped_produto">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-material" role="tabpanel" aria-labelledby="v-pills-material-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param203" data-target="#collapse-param203" data-toggle="collapse">
                        <label for="atualiza_preco_material_reposicao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param203">
                            01. Atualiza preço material ao gravar material
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param203" class="collapse" aria-labelledby="param203" data-parent="#v-pills-material">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Atualiza preço material com o preço de reposição ao gravar
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroMaterial" id="atualiza_preco_material" name="atualiza_preco_material">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param204" data-target="#collapse-param204" data-toggle="collapse">
                        <label for="gravar_expedicao_desdobramento_lote">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param204">
                            02. Gravar expedição ao desdobrar lote de malha
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param204" class="collapse" aria-labelledby="param204" data-parent="#v-pills-material">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Com essa opção ativa, irá abrir um painel que permitirá escolher o número do pedido que deseja gerar a expedição.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroMaterial" id="gravar_expedicao_desdobramento" name="gravar_expedicao_desdobramento">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param205" data-target="#collapse-param205" data-toggle="collapse">
                        <label for="busca_notas_apos_alteracao_preco">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param205">
                            03. Na tela "Mercadorias" considera somente as notas após alteração do preço de custo.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param205" class="collapse" aria-labelledby="param205" data-parent="#v-pills-material">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Com essa opção ativada, apenas as notas com preço de custo já alterado serão consideradas.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroMaterial" id="busca_notas_apos_alteracao_preco" name="busca_notas_apos_alteracao_preco">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param214" data-target="#collapse-param214" data-toggle="collapse">
                        <label for="bloqueia_alterar_qtde_transferencia">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param214">
                            04. Bloqueia digitação no campo Quantidade ao ler uma barra na Transferência de Depósito de Material.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param214" class="collapse" aria-labelledby="param214" data-parent="#v-pills-material">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Com essa opção ativada, o campo quantidade fica bloqueiado ao ler uma barra na transfêrencia de depósito.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroMaterial" id="bloqueia_alterar_qtde_transferencia" name="bloqueia_alterar_qtde_transferencia">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-pedido" role="tabpanel" aria-labelledby="v-pills-pedido-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param200" data-target="#collapse-param200" data-toggle="collapse">
                        <label for="busca_preco_cor_tam">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param33">
                            01. Considerar a busca do preço por cor e tamanho.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param200" class="collapse" aria-labelledby="param200" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Ao inserir um produto na tela de pedido, irá realizar a busca nos preços por cor e tamanho.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido" id="busca_preco_cor_tam" name="busca_preco_cor_tam">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param207" data-target="#collapse-param207" data-toggle="collapse">
                        <label for="busca_preco_cor_tam">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param33">
                            02. Status de liberação comercial.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param207" class="collapse" aria-labelledby="param207" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Ao incluir um pedido, define o status de liberação comercial do mesmo.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido" id="status_lib_comercial_ped" name="busca_preco_cor_tam">
                              <option value="0">Bloqueado</option>
                              <option value="1">Liberado</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param208" data-target="#collapse-param208" data-toggle="collapse">
                        <label for="busca_preco_cor_tam">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param33">
                            03. Status de liberação financeiro.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param208" class="collapse" aria-labelledby="param208" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Ao incluir um pedido, define o status de liberação financeiro do mesmo.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido" id="status_lib_financeiro_ped" name="busca_preco_cor_tam">
                              <option value="0">Bloqueado</option>
                              <option value="1">Liberado</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param209" data-target="#collapse-param209" data-toggle="collapse">
                        <label for="ped_considera_estoque_pend">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param33">
                            04. Validar quantidades em estoque/pendentes ao incluir item em pedido.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param209" class="collapse" aria-labelledby="param209" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Ao incluir item em pedido, valida se existe quantidade disponível em estoque, considerando ou não outros pedidos pendentes.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido" id="ped_considera_estoque_pend" name="ped_considera_estoque_pend">
                              <option value="0">Não</option>
                              <option value="1">Estoque - Pedidos Pendentes</option>
                              <option value="2">Somente Estoque</option>
                              <option value="3">Estoque - (Pedidos Pendentes + Produção) </option>
                              <option value="4">Somente Produção </option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param46" data-target="#collapse-param460" data-toggle="collapse">
                        <label for="utilizaVendedorItem">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param46">
                            05. Permite alterar o preço do item no pedido.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param460" class="collapse" aria-labelledby="param460" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Permite alterar o preço do item no pedido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido" id="permiteAlterarPrecoPedido" name="permiteAlterarPrecoPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#bloqueiaPedidoItemSemTabPreco" data-toggle="collapse">
                        <label for="paramPedido06">
                          <span class="primary-color-dark semi-bold">
                            06. Bloqueia adicionar item sem cadastro na tabela de preço no pedido.
                          </span>
                        </label>
                      </div>
                      <div id="bloqueiaPedidoItemSemTabPreco" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se bloqueia adicionar um item sem cadastro na tabela de preço.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#bloqueiaPedidoAoAlterar" data-toggle="collapse">
                        <label for="paramPedido07">
                          <span class="primary-color-dark semi-bold">
                            07. Bloqueia novamente ao alterar o pedido.
                          </span>
                        </label>
                      </div>
                      <div id="bloqueiaPedidoAoAlterar" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se bloqueia novamente ao alterar o pedido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim - Apenas Comercial</option>
                              <option value="2">Sim - Apenas Financeiro</option>
                              <option value="3">Sim - Comercial e Financeiro</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#habilitaRegraPromocaoPedido" data-toggle="collapse">
                        <label for="paramPedido07">
                          <span class="primary-color-dark semi-bold">
                            08. Habilita desconto de regra promocional ao incluir produto no pedido.
                          </span>
                        </label>
                      </div>
                      <div id="habilitaRegraPromocaoPedido" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se a opção Desconto Regra Promoção será habilitada ao incluir produto no pedido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim - Desmarcado e habilitado</option>
                              <option value="2">Sim - Marcado e habilitado</option>
                              <option value="3">Sim - Marcado e desabilitado</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#obrigaResponsavelPedido" data-toggle="collapse">
                        <label for="paramPedido07">
                          <span class="primary-color-dark semi-bold">
                            09. Torna obrigatório informar um responsável ao cadastrar um pedido.
                          </span>
                        </label>
                      </div>
                      <div id="obrigaResponsavelPedido" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Torna obrigatório inserir um responsável pelo pedido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#calcOrcaPrecoQtde" data-toggle="collapse">
                        <label for="paramPedido07">
                          <span class="primary-color-dark semi-bold">
                            10. Bloqueia campo preço na inclusão do item no orçamento.
                          </span>
                        </label>
                      </div>
                      <div id="calcOrcaPrecoQtde" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se o campo PRECO fica bloqueado na inclusão do item no orçamento.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Sim</option>
                              <option value="1">Não</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#somaFreteCondicoes" data-toggle="collapse">
                        <label for="paramPedido07">
                          <span class="primary-color-dark semi-bold">
                            11. Somar frete no valor das condições de pagamento do pedido.
                          </span>
                        </label>
                      </div>
                      <div id="somaFreteCondicoes" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Somar frete no valor das condições de pagamento do pedido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#gravarOrdemDig" data-toggle="collapse">
                        <label for="paramPedido07">
                          <span class="primary-color-dark semi-bold">
                            12. Gravar ORDEM conforme a ORDEM_DIG ao gerar pedido a partir de um orçamento.
                          </span>
                        </label>
                      </div>
                      <div id="gravarOrdemDig" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Gravar o campo PEDIDO.ORDEM conforme a PEDIDO.ORDEM_DIG ao gerar pedido a partir de um orçamento.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#gravarPrecoMat" data-toggle="collapse">
                        <label for="paramPedido07">
                          <span class="primary-color-dark semi-bold">
                            13. Define o local de busca preço unitário dos consumos para a formação de preço de venda do produto.
                          </span>
                        </label>
                      </div>
                      <div id="gravarPrecoMat" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define o local de busca preço unitário dos consumos para a formação de preço de venda do produto.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">CARACT_CONS</option>
                              <option value="1">MAT_PRECO</option>
                              <option value="3">MAT_PRECO - Considerando Fator Conv. do Material</option>
                              <option value="2">MAT_PRECO_COR</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#reservaAutomaticaPedido" data-toggle="collapse">
                        <label for="paramPedido07">
                          <span class="primary-color-dark semi-bold">
                            14. Reservar automaticamente ao gravar pedido.
                          </span>
                        </label>
                      </div>
                      <div id="reservaAutomaticaPedido" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Insere reserva para os itens do pedido automaticamente.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#considerarRepresentanteUsuarioPedido" data-toggle="collapse">
                        <label for="paramPedido15">
                          <span class="primary-color-dark semi-bold">
                            15. Considerar representante vinculado ao usuário na consulta de pedidos.
                          </span>
                        </label>
                      </div>
                      <div id="considerarRepresentanteUsuarioPedido" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Considerar o representante informado no cadastro do usuário logado na consulta de pedidos.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#naoGerarCondPagto" data-toggle="collapse">
                        <label for="paramPedido16">
                          <span class="primary-color-dark semi-bold">
                            16. Ao transformar orçamento em pedido gravar condição de pagamento apenas na capa.
                          </span>
                        </label>
                      </div>
                      <div id="naoGerarCondPagto" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Quando configurado como 'Sim' fará com que não gere COND_PAGTO.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#duplicataAtraso" data-toggle="collapse">
                        <label for="paramPedido17">
                          <span class="primary-color-dark semi-bold">
                            17. Cliente com duplicatas em atraso
                          </span>
                        </label>
                      </div>
                      <div id="duplicataAtraso" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se é possível fazer um pedido com um cliente que possui duplicatas em atraso.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-8">
                            <select class="input-default parametroPedido">
                              <option value="0">Dar mensagem e permitir seguir</option>
                              <option value="1">Dar mensagem e bloquear</option>
                              <option value="2">Dar mensagem e permitir seguir apenas com senha de supervisor </option>
                              <option value="3">Não controlar </option>
                              <option value="4">Dar mensagem e sugerir atalho para baixa de duplicatas </option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#digitaDepLote" data-toggle="collapse">
                        <label for="paramPedido16">
                          <span class="primary-color-dark semi-bold">
                            18. Digitação de itens por depósito e lote.
                          </span>
                        </label>
                      </div>
                      <div id="digitaDepLote" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Valida depósito e lote ao inserir itens no pedido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" data-target="#alteraDataPedido" data-toggle="collapse">
                        <label for="paramPedido16">
                          <span class="primary-color-dark semi-bold">
                            19. Ao alterar pedido é permitido alterar a data de emissão.
                          </span>
                        </label>
                      </div>
                      <div id="alteraDataPedido" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se é permitido alterar a data de emissão do pedido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-expedicao" role="tabpanel" aria-labelledby="v-pills-expedicao-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param57" data-target="#collapse-param57" data-toggle="collapse">
                        <label for="fatura_expedicao_parcial">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param57">
                            01. Faturar expedição
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param57" class="collapse" aria-labelledby="param57" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Por padrão, nos últimos 3 itens é faturada toda expedição completa.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="fatura_expedicao_parcial" name="fatura_expedicao_parcial">
                              <option value="3">Não permite faturar expedição</option>
                              <option value="0">Não permite faturar parcial</option>
                              <option value="2">Não permite gravar expedição parcial</option>
                              <option value="1">Permite faturar expedição parcial</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param62" data-target="#collapse-param62" data-toggle="collapse">
                        <label for="cancela_expedicao_pendente">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param62">
                            02. Cancela sobras da expedição
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param62" class="collapse" aria-labelledby="param62" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Na expedição parcial, cancelar a quantidade que ficar pendente.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="cancela_expedicao_pendente" name="cancela_expedicao_pendente">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param63" data-target="#collapse-param63" data-toggle="collapse">
                        <label for="painel_conferencia_caixas">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param63">
                            03. Conferência de caixas no embarque
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param63" class="collapse" aria-labelledby="param63" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Habilita painel para realizar a conferência de caixas na tela de embarque
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="painel_conferencia_caixas" name="painel_conferencia_caixas">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param65" data-target="#collapse-param65" data-toggle="collapse">
                        <label for="painel_layout_nfe">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param65">
                            04. Layout de impressão de NF-e da expedição
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param65" class="collapse" aria-labelledby="param65" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define qual layout de NF-e será impresso na expedição
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="painel_conferencia_caixas" name="painel_conferencia_caixas">
                              <option value="0">NF-e</option>
                              <option value="1">NF-e Simplificada</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param67" data-target="#collapse-param67" data-toggle="collapse">
                        <label for="param_status_saida">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param67">
                            05. Status destino após liberar expedição
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param67" class="collapse" aria-labelledby="param67" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define o status que será alterado o pedido ao liberá-lo para expedição.
                              </span>
                            </small>
                          </div>
                          <div class="col-md-8">
                            <div class="form-group col-12">
                              <label data-error="wrong" data-success="right" for="txtStatus">Status</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control validate parametroExpedicao" required="required" id="txtStatus" name="txtStatus" class="form-control" placeholder="Status">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-Status" name="btn-Status" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Status" name="btn-limpa-StatusExp" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param69" data-target="#collapse-param69" data-toggle="collapse">
                        <label for="define_volumes_manualmente">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param69">
                            06. Define volumes manualmente
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param69" class="collapse" aria-labelledby="param69" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Habilita campo volumes dentro da expedição.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="define_volumes_manualmente" name="define_volumes_manualmente">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param77" data-target="#collapse-param77" data-toggle="collapse">
                        <label for="controla_estoque_exp">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param77">
                            07. Controla estoque ao expedir
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param77" class="collapse" aria-labelledby="param77" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Valida estoque ao bipar os itens da expedição.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="controla_estoque_exp" name="controla_estoque_exp">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param78" data-target="#collapse-param78" data-toggle="collapse">
                        <label for="epc_expedicao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param78">
                            08. Utiliza EPC na expedição
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param78" class="collapse" aria-labelledby="param78" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Usa integração EPC na expedição.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="epc_expedicao" name="epc_expedicao">
                              <option value="0">Não</option>
                              <option value="1">Itag Monitor</option>
                              <option value="2">Contare</option>
                              <option value="3">API Sisplan</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param87" data-target="#collapse-param87" data-toggle="collapse">
                        <label for="epc_expedicao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param87">
                            09. Considerar condição de pagamento do pedido
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param87" class="collapse" aria-labelledby="param87" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Considera a condição de pagamento do pedido (tabela COND_PAGTO) ao faturar na expedição.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="busca_cond_pedido_exp" name="busca_cond_pedido_exp">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param673" data-target="#collapse-param673" data-toggle="collapse">
                        <label for="param_status_saida">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param673">
                            10. Percentual permitido para faturar (material)
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param673" class="collapse" aria-labelledby="param673" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define o percentual máximo permitido para expedir além do pedido (material).
                              </span>
                            </small>
                          </div>
                          <div class="col-md-4">
                            <div class="form-group col-12">
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control validate parametroExpedicao" required="required" id="txtPercMaxExpMat" name="txtPercMaxExpMat" class="form-control" placeholder="% máximo">
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param290" data-target="#collapse-param290" data-toggle="collapse">
                        <label for="param_status_saida">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param290">
                            11. Status destino ao gravar a expedição.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param290" class="collapse" aria-labelledby="param290" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define o status que será alterado o pedido ao finalizar a expedição.
                              </span>
                            </small>
                          </div>
                          <div class="col-md-8">
                            <div class="form-group col-12">
                              <label data-error="wrong" data-success="right" for="txtStatusExp">Status</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control validate parametroExpedicao" required="required" id="txtStatusExp" name="txtStatusExp" class="form-control" placeholder="Status">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-StatusExp" name="btn-StatusExp" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-StatusExp" name="btn-limpa-StatusExp" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramBloqueiaPedidosExp" data-target="#collapse-paramBloqueiaPedidosExp" data-toggle="collapse">
                        <label for="fatura_expedicao_parcial">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramBloqueiaPedidosExp">
                            12. Impede expedição de pedido bloqueado.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramBloqueiaPedidosExp" class="collapse" aria-labelledby="paramBloqueiaPedidosExp" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá impedir ou não a expedição de pedidos bloqueados no comercial, financeiro ou ambos.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="bloqueiaPedidosExp" name="bloqueiaPedidosExp">
                              <option value="0">Não impede</option>
                              <option value="1">Somente Comercial</option>
                              <option value="2">Somente Financeiro</option>
                              <option value="3">Comercial e Financeiro</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-sistema" role="tabpanel" aria-labelledby="v-pills-sistema-tab">
                    <div class="card group-default">
                      <div class="card-header" id="paramsis1" data-target="#collapse-paramsis1" data-toggle="collapse">
                        <label for="utiliza_barra_log_sistema">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramsis1">
                            01. Empresa utiliza BarraLog
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramsis1" class="collapse" aria-labelledby="paramsis1" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se a empresa utiliza BarraLog, utilizado nas telas com opção de bipagem (menos loja).
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-5">
                            <select class="input-default parametroSistema" id="utiliza_barra_log_sistema" name="utiliza_barra_log_sistema">
                              <option value="0">Não</option>
                              <option value="1">Sim - Aceita BarraLog e outras barras</option>
                              <option value="2">Sim - Somente BarraLog</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-sistema-02" data-toggle="collapse">
                        <label for="paramSis02">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param68">
                            02. Quantidade de casas decimais que a empresa trabalha
                          </span>
                        </label>
                      </div>
                      <div id="collapse-sistema-02" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define a quantidade de casas decimais que a empresa trabalha (venda, faturamento, nfce...)
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-5">
                            <select class="input-default parametroSistema">
                              <option value="0">2 casas decimais</option>
                              <option value="1">3 casas decimais</option>
                              <option value="2">4 casas decimais</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-sistema-03" data-toggle="collapse">
                        <label for="paramSis03">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param68">
                            03. Filtrar apenas clientes/vendas vinculados ao Representante que estiver configurado.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-sistema-03" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define que irá apenas mostrar clientes/vendas vinculados ao representante informado no cadastro de usuário.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroSistema">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-sistema-04" data-toggle="collapse">
                        <label for="paramSis04">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param689">
                            04. Utiliza EPC.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-sistema-04" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Usa integração EPC no sistema.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroSistema">
                              <option value="0">Não</option>
                              <option value="1">Itag Monitor</option>
                              <option value="2">Contare</option>
                              <option value="3">API Sisplan</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-sistema-05" data-toggle="collapse">
                        <label for="paramSis05">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param690">
                            05. Controla por Local.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-sistema-05" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Controla por Local.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroSistema">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams show active" id="v-pills-entidade" role="tabpanel" aria-labelledby="v-pills-entidade-tab">
                    <div class="card group-default">
                      <div class="card-header" id="paramEnt1" data-target="#collapse-paramEnt1" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt1">
                            01. Permitir incluir e/ou alterar limite de crédito na entidade.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt1" class="collapse" aria-labelledby="paramEnt1" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se será permitido incluir e/ou alterar o campo Limite de Crédito na aba venda do cadastro de entidade.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="altera_limite_credito" name="altera_limite_credito">
                              <option value="0">Não permitir na Alteração</option>
                              <option value="2">Não permitir na Inclusão e Alteração</option> <!-- necessário ser 2 para não alterar os clientes que já estavam cadastrados com Sim -->
                              <option value="1">Permitir</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-paramEnt2" data-toggle="collapse">
                        <label for="paramEntidade02">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt2">
                            02. Permitir incluir e/ou alterar limite fidelidade na entidade.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt2" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se será permitido incluir e/ou alterar o campo Limite Fidelidade na aba venda do cadastro de entidade.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="altera_limite_fidelidade" name="altera_limite_fidelidade">
                              <option value="0">Não permitir na Alteração</option>
                              <option value="2">Não permitir na Inclusão e Alteração</option> <!-- necessário ser 2 para não alterar os clientes que já estavam cadastrados com Sim -->
                              <option value="1">Permitir</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-paramEnt3" data-toggle="collapse">
                        <label for="paramEntidade03">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt3">
                            03. Ao cadastrar uma entidade (cliente), lançar como bloqueado.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt3" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define que toda vez que gravar uma entidade nova, a mesma irá como bloqueada.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="cadastra_entidade_bloqueada" name="cadastra_entidade_bloqueada">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-paramEnt4" data-toggle="collapse">
                        <label for="paramEntidade04">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt4">
                            04. Bloqueia edição de cadastro de entidade(cliente).
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt4" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Bloqueia edição de cadastro de entidade(cliente), apenas os módulos de contato e endereço de cobrança ou entrega caso usuário for do tipo USUÁRIO.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="bloqueia_edicao_entidade" name="bloqueia_edicao_entidade">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-paramEnt5" data-toggle="collapse">
                        <label for="paramEntidade05">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt5">
                            05. Utilizar controle do limite de crédito conforme cadastrado nos valores padrões.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt5" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Validação de limite de crédito conforme cadastro nos valores padrões.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="controle_limite_credito" name="controle_limite_credito">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-paramEnt6" data-toggle="collapse">
                        <label for="paramEntidade06">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt6">
                            06. Obriga informar o Porte da Empresa quando o Tipo Pessoa for jurídica.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt6" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se será permitido gravar o cadastro da entidade sem informar o Porte da Empresa quando o Tipo Pessoa for jurídica.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="obriga_porte_pj" name="obriga_porte_pj">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-paramEnt07" data-toggle="collapse">
                        <label for="paramEntidade07">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt07">
                            07. Permitir incluir e/ou alterar o grupo na entidade.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt07" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se será permitido incluir e/ou alterar o campo Grupo da aba Adicional do cadastro de entidade.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="altera_grupo" name="altera_grupo">
                              <option value="0">Não permitir na Alteração</option>
                              <option value="2">Não permitir na Inclusão e Alteração</option> <!-- necessário ser 2 para não alterar os clientes que já estavam cadastrados com Sim -->
                              <option value="1">Permitir</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-paramEnt08" data-toggle="collapse">
                        <label for="paramEntidade07">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt08">
                            08. Permitir alterar os campos "Tipo" e "CNPJ/CPF".
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt08" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se será permitido alterar os campos "Tipo" e "CNPJ/CPF".
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="altera_Tipo_CNPJ_CPF" name="altera_Tipo_CNPJ_CPF">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-paramEnt09" data-toggle="collapse">
                        <label for="paramEntidade07">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt09">
                            09. Bloquear inclusão de cliente quando o CPF/CNPJ for inválido.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt09" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se será bloqueado a inclusão de cliente quando o CPF/CNPJ for inválido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="bloq_inc_cliente_invalido" name="bloq_inc_cliente_invalido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-pedidob2b" role="tabpanel" aria-labelledby="v-pills-pedidob2b-tab">
                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b1" data-target="#collapse-paramPedidob2b1" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b1">
                            01. Cliente com duplicatas em atraso
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b1" class="collapse" aria-labelledby="paramPedidob2b1" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá mostrar as duplicatas em atraso do cliente.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="dupli_atraso" name="dupli_atraso">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b2" data-target="#collapse-paramPedidob2b2" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b2">
                            02. Permite editar campos Responsável e Vendedor vinculados ao usuário
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b2" class="collapse" aria-labelledby="paramPedidob2b2" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se o usuário pode alterar o Responsável e Vendedor vinculados.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="alteraCamposVinculados" name="alteraCamposVinculados">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b3" data-target="#collapse-paramPedidob2b3" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b3">
                            03. Permite alterar Tabela de Preço
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b3" class="collapse" aria-labelledby="paramPedidob2b3" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se o usuário pode alterar a Tabela de Preço.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="bloqueiaCampos" name="bloqueiaCampos">
                              <option value="0">Campo Inativo para Alteração</option>
                              <option value="1">Qualquer usuário pode alterar</option>
                              <option value="2">Alteração apenas por nível Master</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b4" data-target="#collapse-paramPedidob2b4" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b4">
                            04. Tabela de preço padrão
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b4" class="collapse" aria-labelledby="paramPedidob2b4" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define a tabela padrão ao iniciar um atendimento B2B.
                              </span>
                            </small>
                          </div>
                          <div class="col-md-8">
                            <div class="form-group col-12">
                              <label data-error="wrong" data-success="right" for="txtTabela">Tabela</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control validate parametroPedidob2b" required="required" id="txtTabela-b2b" name="txtTabela-b2b" class="form-control" placeholder="Tabela">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-tabela-b2b" name="btn-tabela-b2b" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-tabela-b2b" name="btn-limpa-tabela-b2b" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b5" data-target="#collapse-paramPedidob2b5" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b5">
                            05. Busca tabela de preço
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b5" class="collapse" aria-labelledby="paramPedidob2b5" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define de onde irá buscar a tabela de preço automaticamente ao iniciar um atendimento.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="buscaTabelaRepresentante" name="buscaTabelaRepresentante">
                              <option value="0"> Não busca automaticamente</option>
                              <option value="1"> Vinculada ao Representante</option>
                              <option value="2"> Padrão Comercial</option>
                              <option value="3"> Vinculada ao Cliente</option>
                              <option value="4"> Informada no Parâmetro</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b6" data-target="#collapse-paramPedidob2b6" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b6">
                            06. Prazo máximo vencimento do cheque
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b6" class="collapse" aria-labelledby="paramPedidob2b6" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define quantos dias o cheque ficara como vencido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <div class="form-group col-12">
                              <label data-error="wrong" data-success="right" for="txtDiasVencimentoCheque">Dias:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control validate parametroPedidob2b" required="required" id="txtDiasVencimentoCheque" name="txtDiasVencimentoCheque" class="form-control" placeholder="Dias">
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b7" data-target="#collapse-paramPedidob2b7" data-toggle="collapse">
                        <label for="permite_precoManual">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b7">
                            07. Permite alterar preço manual
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b7" class="collapse" aria-labelledby="paramPedidob2b7" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se o usuário pode alterar preço manualmente nas cores dos itens do pedido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="alteraPrecoManualPedido" name="alteraPrecoManualPedido">
                              <option value="0"> Não permite alterar preço manualmente</option>
                              <option value="1"> Permite alterar preço manualmente</option>
                              <option value="2"> Permite alterar preço (maior o preço original da tabela)</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b8" data-target="#collapse-paramPedidob2b8" data-toggle="collapse">
                        <label for="permite_precoManual">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b8">
                            08. Consultar clientes bloqueados
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b8" class="collapse" aria-labelledby="paramPedidob2b8" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se o usuário pode consultar cliente bloqueado no pedido b2b.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="alteraPrecoManualPedido" name="alteraPrecoManualPedido">
                              <option value="0"> Permite consultar cliente bloqueado</option>
                              <option value="1"> Não permite consultar cliente bloqueado</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b9" data-target="#collapse-paramPedidob2b9" data-toggle="collapse">
                        <label for="permite_precoManual">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b9">
                            09. Obriga o campo 'Entrega' ser maior que a data atual.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b9" class="collapse" aria-labelledby="paramPedidob2b9" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                A validação é aplicada se o campo 'Entrega' estiver preenchido. Se estiver vazio, é gravado um dia anterior à data de emissão.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="alteraPrecoManualPedido" name="alteraPrecoManualPedido">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b10" data-target="#collapse-paramPedidob2b10" data-toggle="collapse">
                        <label for="bloqueia_editarPedido">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b10">
                            10. Bloqueia opção Editar
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b10" class="collapse" aria-labelledby="paramPedidob2b10" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define bloqueio da opção "Editar".
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="bloqueiaEditar" name="bloqueiaEditar">
                              <option value="0"> Não</option>
                              <option value="1"> Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-sisplanFiscal" role="tabpanel" aria-labelledby="v-pills-sisplanFiscal-tab">
                    <div id="loja_sisplanFiscal">
                      <div class="card group-default">
                        <div class="card-header" id="paramSisplanFiscal1" data-target="#collapse-paramSisplanFiscal1" data-toggle="collapse">
                          <label for="permite_precoManual">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramSisplanFiscal1">
                              01. Configuração do SPED Fiscal - SIS - 270
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramSisplanFiscal1" class="collapse" aria-labelledby="paramSisplanFiscal1" data-parent="#loja_sisplanFiscal">
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaSisplanFiscal270" class="display">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaAjudaSisplanFiscal270" class="table table-responsive-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramSisplanFiscal2" data-target="#collapse-paramSisplanFiscal2" data-toggle="collapse">
                          <label for="permite_precoManual">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramSisplanFiscal2">
                              02. Configuração do SPED Fiscal - SIS - 280
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramSisplanFiscal2" class="collapse" aria-labelledby="paramSisplanFiscal2" data-parent="#loja_sisplanFiscal">
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaSisplanFiscal280" class="display">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaAjudaSisplanFiscal280" class="table table-responsive-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramSisplanFiscal3" data-target="#collapse-paramSisplanFiscal3" data-toggle="collapse">
                          <label for="permite_precoManual">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramSisplanFiscal3">
                              03. Configuração do Sintegra - SIS - 670
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramSisplanFiscal3" class="collapse" aria-labelledby="paramSisplanFiscal3" data-parent="#loja_sisplanFiscal">
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaSisplanFiscal670" class="display">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaAjudaSisplanFiscal670" class="table table-responsive-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-escritural" role="tabpanel" aria-labelledby="v-pills-escritural-tab">
                    <div class="card group-default">
                      <div class="card-header" id="paramCieloEmpLogada" data-target="#collapse-paramCieloEmpLogada" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramCieloEmpLogada">
                            01. Buscar extrato Cielo somente da empresa logada
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramCieloEmpLogada" class="collapse" aria-labelledby="paramCieloEmpLogada" data-parent="#loja_content">
                        <div class="card-body pt-2 row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                No retorno de cartões CIELO, considerar para buscar somente extrato da empresa logada.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEscritural" id="extratoEmpLogada" name="extratoEmpLogada">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="paramBorderoSeq" data-target="#collapse-paramBorderoSeq" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramBorderoSeq">
                            02. Gera número de bordero sequencial (EscEnvio)
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramBorderoSeq" class="collapse" aria-labelledby="paramBorderoSeq" data-parent="#loja_content">
                        <div class="card-body pt-2 row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Gerar o Bordero Sequencial para Todas as Empresas.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEscritural" id="borderoSequencial" name="borderoSequencial">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="paramBoletoAntecipacao" data-target="#collapse-paramBoletoAntecipacao" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramBoletoAntecipacao">
                            03. Emite boleto a partir de uma antecipação (EscEnvio).
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramBoletoAntecipacao" class="collapse" aria-labelledby="paramBoletoAntecipacao" data-parent="#loja_content">
                        <div class="card-body pt-2 row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Permite emitir boleto a partir de uma antecipação
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEscritural" id="boletoAntecipacao" name="boletoAntecipacao">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="paramSomaValorTarifa" data-target="#collapse-paramSomaValorTarifa" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramSomaValorTarifa">
                            04. Ao realizar a baixa de um título, soma o valor da tarifa no valor pago para fazer o lançamento contábil.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramSomaValorTarifa" class="collapse" aria-labelledby="paramSomaValorTarifa" data-parent="#loja_content">
                        <div class="card-body pt-2 row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Soma o valor da tarifa no valor pago para fazer o lançamento contábil.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEscritural" id="somaValorTarifa" name="somaValorTarifa">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="paramContaCorUnica" data-target="#collapse-paramContaCorUnica" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramContaCorUnica">
                            05. Para cartão Cielo, Rede ou GetNet, ao confirmar pagamento, gera conta corrente único para todas as baixas do cartão.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramContaCorUnica" class="collapse" aria-labelledby="paramContaCorUnica" data-parent="#loja_content">
                        <div class="card-body pt-2 row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Permite emitir boleto a partir de uma antecipação
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEscritural" id="contaCorUnica" name="contaCorUnica">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="paramDiferencaAcrescimoDesconto" data-target="#collapse-paramDiferencaAcrescimoDesconto" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramDiferencaAcrescimoDesconto">
                            06. Diferença em desconto ou acréscimo quando o valor pago no cartão for até X centavos.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramDiferencaAcrescimoDesconto" class="collapse" aria-labelledby="paramDiferencaAcrescimoDesconto" data-parent="#loja_content">
                        <div class="card-body pt-2 row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Para Safra e Rede, joga a diferença em desconto ou acrescimo quando diferença entre o saldo pendente da duplicata e o valor pago no cartão for até X centavos.<br>
                                (Configurar os centavos no cadastro de valores padrão, se não é 5 centavos por padrão)
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEscritural" id="diferencaAcrescimoDesconto" name="diferencaAcrescimoDesconto">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="paramGeraBorderoRelBloqueto" data-target="#collapse-paramGeraBorderoRelBloqueto" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramGeraBorderoRelBloqueto">
                            07. Gerar e gravar o número do borderô ao clicar em "Imprimir".
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramGeraBorderoRelBloqueto" class="collapse" aria-labelledby="paramGeraBorderoRelBloqueto" data-parent="#loja_content">
                        <div class="card-body pt-2 row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Gera e grava o próximo número de borderô ao clicar em "Imprimir" na tela de Relatório de Bloqueto.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEscritural" id="geraBorderoRelBloqueto" name="geraBorderoRelBloqueto">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-faccao" role="tabpanel" aria-labelledby="v-pills-faccao-tab">
                    <div id="loja_faccao">
                      <div class="card group-default">
                        <div class="card-header" id="paramFaccao1" data-target="#collapse-paramFaccao1" data-toggle="collapse">
                          <label for="permite_precoManual">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramFaccao1">
                              01. Configuração movimentação facção - FAC - 310
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramFaccao1" class="collapse" aria-labelledby="paramFaccao1" data-parent="#loja_faccao">
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaFaccao310" class="display">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaAjudaFaccao310" class="table table-responsive-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramFaccao2" data-target="#collapse-paramFaccao2" data-toggle="collapse">
                          <label for="permite_precoManual">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramFaccao2">
                              02. Configuração movimentação facção - FAC - 500
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramFaccao2" class="collapse" aria-labelledby="paramFaccao2" data-parent="#loja_faccao">
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaFaccao500" class="display">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaAjudaFaccao500" class="table table-responsive-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramOrdemProducao3" data-target="#collapse-paramOrdemProducao3" data-toggle="collapse">
                          <label for="nfce_natureza_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramOrdemProducao3">
                              03. Cliente que será lançada a ordem de produção
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramOrdemProducao3" class="collapse" aria-labelledby="paramOrdemProducao3" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Cliente que será lançada a ordem de produção.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtEntidadeOrdemProducao">Cliente</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroOrdemProducao" required="required" id="txtEntidadeOrdemProducao" name="txtEntidadeOrdemProducao" class="form-control" placeholder="Entidade">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-EntidadeOrdemProducao" name="btn-EntidadeOrdemProducao" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-EntidadeOrdemProducao" name="btn-limpa-EntidadeOrdemProducao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramOrdemProducao4" data-target="#collapse-paramOrdemProducao4" data-toggle="collapse">
                          <label for="nfce_natureza_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramOrdemProducao4">
                              04. Quantidade de dígitos do número da OF
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramOrdemProducao4" class="collapse" aria-labelledby="paramOrdemProducao4" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Quantidade de dígitos do número da OF.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroOrdemProducao" id="cbQtdeDigitoNumeroOF" name="cbQtdeDigitoNumeroOF">
                                <option value="0">6</option>
                                <option value="1">7</option>
                                <option value="2">8</option>
                                <option value="3">9</option>
                                <option value="4">10</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="paramOrdemProducao5" data-target="#collapse-paramOrdemProducao5" data-toggle="collapse">
                          <label for="permite_qtde_fracionada">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramOrdemProducao5">
                              05. Permite o cadastro e movimentação de ordem de produção com quantidade fracionada.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-paramOrdemProducao5" class="collapse" aria-labelledby="paramOrdemProducao5" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o cadastro e movimentação de ordem de produção irá permitir quantidade fracionada.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroOrdemProducao" id="permiteQtdeFracionada" name="permiteQtdeFracionada">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-contabil" role="tabpanel" aria-labelledby="v-pills-contabil-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param202" data-target="#collapse-param202" data-toggle="collapse">
                        <label for="geraContabil">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param202">
                            01. Gerar Contábil
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param202" class="collapse" aria-labelledby="param202" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se a empresa irá gerar Contábil
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroContabil" id="geraContabil" name="geraContabil">
                              <option value="0">Não gera</option>
                              <option value="1">Gera fiscal/financeiro</option>
                              <option value="2">Gera fiscal</option>
                              <option value="3">Gera financeiro</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="paramCont02" data-target="#collapse-paramCont02" data-toggle="collapse">
                        <label for="geraContabil">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramCont02">
                            02. Validação Contábil
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramCont02" class="collapse" aria-labelledby="paramCont02" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se o contábil será gerado validando todas as tabelas ou apenas a ConfContabil, configurada na tela ConfigContabil (ERP).
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroContabil" id="configContabil" name="configContabil">
                              <option value="0">Padrão - valida todas as tabelas</option>
                              <option value="1">ConfContabil - financeiro/produção</option>
                              <option value="2">ConfContabil - fiscal</option>
                              <option value="3">ConfContabil - financeiro/produção e fiscal</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade scrollParams" id="v-pills-compras" role="tabpanel" aria-labelledby="v-pills-compras-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param206" data-target="#collapse-param206" data-toggle="collapse">
                        <label for="geraVendaDevolucao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param206">
                            01. Gerar venda de devolução
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param206" class="collapse" aria-labelledby="param206" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá fazer pergunta se deseja gerar venda de devolução ao gravar a nota de entrada.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroCompras" id="geraVendaDevolucao" name="geraVendaDevolucao">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param210" data-target="#collapse-param210" data-toggle="collapse">
                        <label for="geraVendaDevolucao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param210">
                            02. Considerar unidade dos itens do XML ao dar entrada.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param210" class="collapse" aria-labelledby="param210" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá comparar as unidades dos itens do sistema com as do XML. Caso sejam iguais, a unidade de conversão passa a ser 1 automaticamente.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroCompras" id="considerarUnidadeXML" name="considerarUnidadeXML">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param21034" data-target="#collapse-param21034" data-toggle="collapse">
                        <label for="geraVendaDevolucao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param21034">
                            03. Gerar antecipação ao gravar entrada de nota.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param21034" class="collapse" aria-labelledby="param21034" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá gerar uma antecipação (receber) ao dar entrada em uma nota.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroCompras" id="geraAnteNfEntra" name="geraAnteNfEntra">
                              <option value="0">Não - Gerar pagar</option>
                              <option value="1">Sim - Gerar antecipação</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param2103497" data-target="#collapse-param2103497" data-toggle="collapse">
                        <label for="geraVendaDevolucao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param2103497">
                            04. Importa apenas capa do XML.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param2103497" class="collapse" aria-labelledby="param2103497" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Importar apenas a capa do XML para realizar a bipagem dos itens.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroCompras" id="importaCapaXml" name="importaCapaXml">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-custos" role="tabpanel" aria-labelledby="v-pills-custos-tab">
                    <div class="scrollParams" id="custos_content">
                      <div class="card group-default">
                        <div class="card-header" id="param1custos" data-target="#collapse-param1custos" data-toggle="collapse">
                          <label for="considerar_consumos_sem_cor_informada">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param1custos">
                              01. Considerar consumos sem cor informada
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param1custos" class="collapse" aria-labelledby="param1custos" data-parent="#custos_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Ao calcular média de consumos, irá considerar consumos sem cor informada (*****).
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroCustos" id="considerar_consumos_sem_cor_informada" name="considerar_consumos_sem_cor_informada">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param2custos" data-target="#collapse-param2custos" data-toggle="collapse">
                          <label for="calcular_media_por_formacao_custos">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param2custos">
                              02. Calcular a média dos consumos por:
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param2custos" class="collapse" aria-labelledby="param2custos" data-parent="#custos_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Forma como a média dos consumos será calculada.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroCustos" id="calcular_media_por_formacao_custos" name="calcular_media_por_formacao_custos">
                                <option value="0">Tamanho</option>
                                <option value="1">Cor</option>
                                <option value="2">Tamanho e cor</option>
                                <option value="3">Média dos tamanhos e cores</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param3custos" data-target="#collapse-param3custos" data-toggle="collapse">
                          <label for="buscar_mao_de_obra_de">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param3custos">
                              03. Buscar mão de obra de:
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param3custos" class="collapse" aria-labelledby="param3custos" data-parent="#custos_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  De onde a mão de obra será buscada.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroCustos" id="buscar_mao_de_obra_de" name="buscar_mao_de_obra_de">
                                <option value="0">Tempos (Custo)</option>
                                <option value="1">Setores</option>
                                <option value="2">Tempos (Preço Tempos)</option>
                                <option value="3">Preço Terceiros</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param60Custos" data-target="#collapse-param60Custos" data-toggle="collapse">
                          <label for="abc">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param60Custos">
                              04. Cálculo de preço
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param60Custos" class="collapse" aria-labelledby="param60Custos" data-parent="#custos_content">
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaCustos60" class="display">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaAjudaCustos60" class="table table-responsive-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param5custos" data-target="#collapse-param5custos" data-toggle="collapse">
                          <label for="permitir_alterar_custo_item">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param5custos">
                              05. Permitir alterar custo dos itens na formação de custos
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param5custos" class="collapse" aria-labelledby="param5custos" data-parent="#custos_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o campo para alterar o custo dos itens estará habilitado.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroCustos" id="permitir_alterar_custo_item" name="permitir_alterar_custo_item">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param6custos" data-target="#collapse-param6custos" data-toggle="collapse">
                          <label for="permitir_alterar_custo_item">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param6custos">
                              06. Habilitar gráfico e foto do produto na formação de custos
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param6custos" class="collapse" aria-labelledby="param5custos" data-parent="#custos_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o gráfico dos percentuais de custo e ou/a foto do produto estarão habilitados.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroCustos" id="permitir_alterar_custo_item" name="permitir_alterar_custo_item">
                                <option value="0">Gráfico e foto</option>
                                <option value="1">Gráfico</option>
                                <option value="2">Foto</option>
                                <option value="3">Nenhum</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="clearfix pt-2 float-right">
                    <button id="btnSalvar" class="btn btn-danger btn-sisp relative"><i class="fas fa-save"></i> Salvar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <!-- /.content -->
    </div>

    <div id="modalLogsParametro" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Logs Parâmetro</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-row">
              <div class="col-12 col-lg-12">
                <div class="form-group col-sm-12 col-12 table-responsive">
                  <table width="100%" style="width: 100%" id="tabelaLogsParametro" class="table table-sm table-hover table-select table-condensed">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <div class="row">
              <button class="btn btn-primary btn-sisp" id="btnFecharModalLogsParametro" style="background-color: #B22222; border-color: #B22222">Fechar</button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div id="modal-exportar-parametros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Exportar Parâmetros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="col-sm-12">
              <p>Selecione as empresas para a qual deseja exportar os parâmetros atuais.</p>
            </div>
            <div class="icheck-danger d-inline">
              <input type="checkbox" id="cbTodasAsEmpresas" class="form-check-input">
              <label for="cbTodasAsEmpresas" class="mb-2">Todas as Empresas</label>
            </div>
            <hr />
            <div id="modal-exportar-body">

            </div>
          </div>
          <div class="modal-footer">
            <div class="row">
              <button id="btn-confirmar-exportacao" class="btn btn-primary btn-sisp btn-primary mr-2">Confirmar</button>
              <button class="btn btn-primary btn-sisp" data-dismiss="modal" style="background-color: #B22222; border-color: #B22222">Fechar</button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div id="modal-exportar-parametros-individual" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Aplicar Parâmetro Empresas</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="col-sm-12">
              <p>Selecione as empresas para a qual deseja aplicar o parâmetro atual.</p>
            </div>
            <div class="icheck-danger d-inline">
              <input type="checkbox" id="cbTodasAsEmpresasIndividual" class="form-check-input">
              <label for="cbTodasAsEmpresasIndividual" class="mb-2">Todas as Empresas</label>
            </div>
            <hr />
            <div id="modal-exportar-individual-body">

            </div>
          </div>
          <div class="modal-footer">
            <div class="row">
              <button id="btn-confirmar-exportacao-individual" class="btn btn-primary btn-sisp btn-primary mr-2">Confirmar</button>
              <button class="btn btn-primary btn-sisp" data-dismiss="modal" style="background-color: #B22222; border-color: #B22222">Fechar</button>
            </div>
          </div>
        </div>
      </div>
    </div>


    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.content-wrapper -->
    <?php
    include_once('../../modais.php');
    ?>
    <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <!-- jQuery -->
  <script src="<?php echo BASE_URI; ?>/plugins/jquery/jquery.min.js?versao=3.259.2.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="<?php echo BASE_URI; ?>/plugins/jquery-ui/jquery-ui.min.js?versao=3.259.2.1"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    if ($('[type="date"]').prop('type') != 'date') {
      $('[type="date"]').datepicker();
    }
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="<?php echo BASE_URI; ?>/plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.259.2.1"></script>
  <!-- ChartJS -->
  <script src="<?php echo BASE_URI; ?>/plugins/chart.js/Chart.min.js?versao=3.259.2.1"></script>
  <!-- Sparkline -->
  <script src="<?php echo BASE_URI; ?>/dist/js/jquery.maskMoney.min.js?versao=3.259.2.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/loadingoverlay.min.js?versao=3.259.2.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/sisplan.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/utils/funcoes.js?versao=3.259.2.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/adminlte.min.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/jquery.dataTables.min.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/dataTables.bootstrap4.min.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/sum().js?versao=3.259.2.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/dataTables.keyTable.js?versao=3.259.2.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/requisicoes.js?versao=3.259.2.1"></script>
  <script src="<?php echo BASE_URI; ?>/utils/funcoes.js?versao=3.259.2.1"></script>
  <script src="<?php echo BASE_URI; ?>/utils/cookies.js?versao=3.259.2.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = "<?php echo BASE_URI; ?>/login"
        return;
      }

      const empId = getCookie('emp_id');
      const temAcesso = await temAcessoTela('PARAMETROS');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, "<?php echo BASE_URI; ?>");
        return;
      }

      async function bUsuarioMaster() {
        try {
          const usuario = await retornaJsonPesquisaPadrao(`{"tabela": "ACESSO_USUARIOS", "camposSelect": ["TIPO"], "WHERE": ["CODIGO = '${getCookie('cod_usuario')}'"] }`) ?? 0;

          return usuario[0].TIPO == '2';

        } catch (error) {
          console.error(error);
        }
      }

      if ((getCookie('cod_usuario') == '0000') || (await bUsuarioMaster())) {
        $('#btn-exportar').removeClass('d-none');
      }

      $('#txtMsgTrocaRodape').on('keypress', function(e) {
        if (e.keyCode == 13) {
          $('#btn-rodape').trigger('click');
        }
      });

      $('#txtMsgTrocaCabecario').on('keypress', function(e) {
        if (e.keyCode == 13) {
          $('#btn-cabecario').trigger('click');
        }
      });

      $('#btn-rodape').on('click', function() {
        $('#txtMsgTrocaRodape').val($('#txtMsgTrocaRodape').val().trim() + '\n');
        $('#txtMsgTrocaRodape').focus();
      });

      $('#btn-cabecario').on('click', function() {
        $('#txtMsgTrocaCabecario').val($('#txtMsgTrocaCabecario').val().trim() + '\n');
        $('#txtMsgTrocaCabecario').focus();
      });

      //carrega parametros
      $.LoadingOverlay("show");
      try {
        try {
          const parametrosLoja = await BuscaParametrosLoja();
          const parametrosReceber = await BuscaParametrosReceber();
          const parametrosFaturamento = await BuscaParametrosFaturamento();
          const parametrosProduto = await BuscaParametrosProduto();
          const parametrosMaterial = await BuscaParametrosMaterial();
          const parametrosExpedicao = await BuscaParametrosExpedicao();
          const parametrosSistema = await BuscaParametrosSistema();
          const parametrosEntidade = await BuscaParametrosEntidade();
          const parametrosPedidoB2B = await BuscaParametrosPedidoB2B();
          const parametrosPedido = await BuscaParametrosPedido();
          const parametrosEscritural = await BuscaParametrosEscritural();
          const parametrosOrdemProducao = await BuscaParametrosOrdemProducao();
          const parametrosContabil = await BuscaParametrosContabil()
          const parametrosCompras = await BuscaParametrosCompras()
          const parametrosCustos = await BuscaParametrosCustos()
          adicionaBotaoLog();
          adicionaBotaoAplicarTodasEmpresas();

          for (let i = 0; i < parametrosLoja.length; i++) {
            $($(`.parametroVenda`)[i]).val(parametrosLoja[i].VALOR);
          }
          for (let i = 0; i < parametrosReceber.length; i++) {
            $($(`.parametroReceber`)[i]).val(parametrosReceber[i].VALOR);
          }
          for (let i = 0; i < parametrosFaturamento.length; i++) {
            $($(`.parametroFaturamento`)[i]).val(parametrosFaturamento[i].VALOR);
          }
          for (let i = 0; i < parametrosExpedicao.length; i++) {
            $($(`.parametroExpedicao`)[i]).val(parametrosExpedicao[i].VALOR);
          }
          for (let i = 0; i < parametrosSistema.length; i++) {
            $($(`.parametroSistema`)[i]).val(parametrosSistema[i].VALOR);
          }
          for (let i = 0; i < parametrosEntidade.length; i++) {
            $($(`.parametroEntidade`)[i]).val(parametrosEntidade[i].VALOR);
          }
          for (let i = 0; i < parametrosPedidoB2B.length; i++) {
            $($(`.parametroPedidob2b`)[i]).val(parametrosPedidoB2B[i].VALOR);
          }
          for (let i = 0; i < parametrosProduto.length; i++) {
            $($(`.parametroProduto`)[i]).val(parametrosProduto[i].VALOR);
          }
          for (let i = 0; i < parametrosMaterial.length; i++) {
            $($(`.parametroMaterial`)[i]).val(parametrosMaterial[i].VALOR);
          }
          for (let i = 0; i < parametrosPedido.length; i++) {
            $($(`.parametroPedido`)[i]).val(parametrosPedido[i].VALOR);
          }
          for (let i = 0; i < parametrosEscritural.length; i++) {
            $($(`.parametroEscritural`)[i]).val(parametrosEscritural[i].VALOR);
          }
          for (let i = 0; i < parametrosOrdemProducao.length; i++) {
            $($(`.parametroOrdemProducao`)[i]).val(parametrosOrdemProducao[i].VALOR);
          }
          for (let i = 0; i < parametrosContabil.length; i++) {
            $($(`.parametroContabil`)[i]).val(parametrosContabil[i].VALOR);
          }
          for (let i = 0; i < parametrosCompras.length; i++) {
            $($(`.parametroCompras`)[i]).val(parametrosCompras[i].VALOR);
          }
          for (let i = 0; i < parametrosCustos.length; i++) {
            $($(`.parametroCustos`)[i]).val(parametrosCustos[i].VALOR);
          }
        } catch (error) {
          console.error(error);
        }
      } finally {
        $.LoadingOverlay("hide");
      }

      await verificaEInsereParametrosPadroes();

      $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
      $('#txtDepositoEcommerce').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
      $('#txtTabela').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao descricao"], "where": null}`);
      $('#txtTabela-b2b').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao descricao"], "where": null}`);
      $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
      $('#txtVendedorAgrup').autocompleta(3, `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where": null}`);
      $('#txtNaturezaNFCE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);
      $('#txtNaturezaCFe').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);
      $('#txtMoedaTroca').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao"], "where": null}`);
      $('#txtOperacaoNFe').autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $('#txtTipoVendaPadrao').autocompleta(1, `JSON={ "tabela":"venda_tipo", "camposSelect":[ "id chave", "descricao"], "where": null}`);
      $('#txtOperacaoNFeDev').autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $('#txtOperacaoNFCe').autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $('#txtOperacaoCFe').autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $('#txtStatusExp').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $('#txtEntidadeOrdemProducao').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);

      $('#btn-deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Depósito', 'deposito');
      $('#btn-depositoEcommerce').pesquisa('#txtDepositoEcommerce', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Depósito', 'deposito');
      $('#btn-tabela').pesquisa('#txtTabela', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, 'Pesquisa Tabela', 'regiao');
      $('#btn-tabela-b2b').pesquisa('#txtTabela-b2b', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, 'Pesquisa Tabela', 'regiao');
      $('#btn-cliente').pesquisa('#txtCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome", "cnpj"]}`, 'Pesquisa Cliente', 'entidade');
      $('#btn-vendedorAgrup').pesquisa('#txtVendedorAgrup', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"]}`, 'Pesquisa Representante', 'represen');
      $('#btn-NaturezaNFCE').pesquisa('#txtNaturezaNFCE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"]}`, 'Pesquisa Natureza', 'natureza');
      $('#btn-NaturezaCFe').pesquisa('#txtNaturezaCFe', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"]}`, 'Pesquisa Natureza', 'natureza');
      $('#btn-MoedaTroca').pesquisa('#txtMoedaTroca', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao"]}`, 'Pesquisa Moeda', 'moeda');
      $('#btn-OperacaoNFe').pesquisa('#txtOperacaoNFe', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Operacao Fiscal', 'Operacao Fiscal');
      $('#btn-TipoVendaPadrao').pesquisa('#txtTipoVendaPadrao', 'ID', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"venda_tipo", "camposSelect":[ "id", "descricao"]}`, 'Pesquisa Tipo Venda', 'Tipo Venda');
      $('#btn-OperacaoNFeDev').pesquisa('#txtOperacaoNFeDev', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Operacao Fiscal', 'Operacao Fiscal');
      $('#btn-OperacaoNFCe').pesquisa('#txtOperacaoNFCe', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Operacao Fiscal', 'Operacao Fiscal');
      $('#btn-OperacaoCFe').pesquisa('#txtOperacaoCFe', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Operacao Fiscal', 'Operacao Fiscal');
      $('#btn-Status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Status', 'SITPROD');
      $('#btn-StatusExp').pesquisa('#txtStatusExp', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Status', 'SITPROD');
      $('#btn-EntidadeOrdemProducao').pesquisa('#txtEntidadeOrdemProducao', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome", "cnpj"]}`, 'Pesquisa Cliente', 'entidade');

      $('#btn-limpa-Status').on('click', function() {
        $('#txtStatus').val('');
      });

      $('#btn-limpa-StatusExp').on('click', function() {
        $('#txtStatusExp').val('');
      });

      $('#btn-limpa-NaturezaNFCE').on('click', function() {
        $('#txtNaturezaNFCE').val('');
      });
      $('#btn-limpa-NaturezaCFe').on('click', function() {
        $('#txtNaturezaCFe').val('');
      });
      $('#btn-limpa-tabela').on('click', function() {
        $('#txtTabela').val('');
      });

      $('#btn-limpa-tabela-b2b').on('click', function() {
        $('#txtTabela-b2b').val('');
      });

      $('#btn-limpa-MoedaTroca').on('click', function() {
        $('#txtMoedaTroca').val('');
      });

      $('#btn-limpa-vendedorAgrup').on('click', function() {
        $('#txtVendedorAgrup').val('');
      });

      $('#btn-limpa-deposito').on('click', function() {
        $('#txtDeposito').val('');
      });

      $('#btn-limpa-depositoEcommerce').on('click', function() {
        $('#txtDepositoEcommerce').val('');
      });

      $('#btn-limpa-cliente').on('click', function() {
        $('#txtCliente').val('');
      });

      $('#btn-limpa-OperacaoNFe').on('click', function() {
        $('#txtOperacaoNFe').val('');
      });

      $('#btn-limpa-TipoVendaPadrao').on('click', function() {
        $('#txtTipoVendaPadrao').val('');
      });

      $('#btn-limpa-OperacaoNFeDev').on('click', function() {
        $('#txtOperacaoNFeDev').val('');
      });

      $('#btn-limpa-OperacaoNFCe').on('click', function() {
        $('#txtOperacaoNFCe').val('');
      });

      $('#btn-limpa-OperacaoCFe').on('click', function() {
        $('#txtOperacaoCFe').val('');
      });

      $('#btn-limpa-EntidadeOrdemProducao').on('click', function() {
        $('#txtEntidadeOrdemProducao').val('');
      });

      $('#txtPercMaxExpMat').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2,
      });

      await buscaParamentrosSisplanFiscal();

      async function buscaParamentrosSisplanFiscal() {
        let param270 = '';
        let param280 = '';
        let param670 = '';
        try {
          let response = await requisicao('GET',
            '/Sisplan/Funcoes/V1/pesquisa?',
            `JSON={ 
              "tabela":"EMP_PARAM", 
              "camposSelect":["EMP_PARAM.VALOR, EMP_PARAM.CODIGO"], 
              "where": ["EMP_PARAM.EMPRESA = '${getCookie('empresa').substring(1)}' AND EMP_PARAM.TIPO = 'SIS' AND EMP_PARAM.CODIGO IN ('270','280', '670')"]
            }`, null);

          if (!response) {
            return;
          }

          const jsonStr = await response.json();
          if (response.status !== 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          if (jsonStr.RESULT[0].length > 0) {
            param270 = jsonStr.RESULT[0].filter(e => e.CODIGO == '270')[0].VALOR;
            param280 = jsonStr.RESULT[0].filter(e => e.CODIGO == '280')[0].VALOR;
            param670 = jsonStr.RESULT[0].filter(e => e.CODIGO == '670')[0].VALOR;
          }

          const dataSetColsModal = [];
          for (let i = 1; i <= 100; i++) {
            dataSetColsModal.push({
              title: `${i}`,
              data: `${i}`,
            });
          }

          let rowData270 = [{}];
          let rowData280 = [{}];
          let rowData670 = [{}];
          for (let i = 1; i <= 100; i++) {
            const input270 = `<input type="text" class="input-default focus form-control param270Fis" id="param270Fis${i}" maxlength="1" valorOrig="${param270[i - 1] != undefined ? param270[i - 1] : ''}" value="${param270[i - 1] != undefined ? param270[i - 1] : ''}">`
            rowData270[0][i] = input270;
            const input280 = `<input type="text" class="input-default focus form-control param280Fis" id="param280Fis${i}" maxlength="1" valorOrig="${param280[i - 1] != undefined ? param280[i - 1] : ''}" value="${param280[i - 1] != undefined ? param280[i - 1] : ''}">`
            rowData280[0][i] = input280;
            const input670 = `<input type="text" class="input-default focus form-control param670Fis" id="param670Fis${i}" maxlength="1" valorOrig="${param670[i - 1] != undefined ? param670[i - 1] : ''}" value="${param670[i - 1] != undefined ? param670[i - 1] : ''}">`
            rowData670[0][i] = input670;
          }

          criaDataTablePadrao('#tabelaSisplanFiscal270', false, false, false, false, true, true, '100px', rowData270, dataSetColsModal);
          criaDataTablePadrao('#tabelaSisplanFiscal280', false, false, false, false, true, true, '100px', rowData280, dataSetColsModal);
          criaDataTablePadrao('#tabelaSisplanFiscal670', false, false, false, false, true, true, '100px', rowData670, dataSetColsModal);
          await buscaAjudaSisplanFiscal();
        } catch (error) {
          console.log('Erro ao buscar os parâmetros do sisplan fiscal: ' + error);
        }
      }

      async function verificaEInsereParametrosPadroes() {
        $.LoadingOverlay('show');
        try {

          const insereParametros = async () => {
            $.LoadingOverlay('show');
            const response = await requisicao('GET', '/sisplan/parametro/v1/insereparametrospadroes?', '', '', 70000);

            if (!response) {
              msgErro('Não foi possível inserir os parâmetros padrões! Verifique e tente novamente.');
              $.LoadingOverlay('hide');
              return;
            }

            if (response.status != 200) {
              msgErro('Não foi possível inserir os parâmetros padrões! Verifique e tente novamente.');
              $.LoadingOverlay('hide');
              return;
            }

            $.LoadingOverlay('hide');

            criaMensagemSucesso('Parâmetros padrões inseridos com sucesso. Por favor, faça o login novamente.', () => {
              parent.mandarParaLogin()
            });
          }
          const pesquisaExisteParametro = {
            tabela: 'LOJA_PARAM',
            camposSelect: ['COUNT(*)'],
            where: [`EMP_ID = ${getCookie('emp_id')}`]
          }

          const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaExisteParametro));

          if (json[0].COUNT <= 0) {
            $.LoadingOverlay('hide');

            msgAguardaConfirmacao('Empresa nova, não tem os parâmetros padrões inseridos na tabela, clique em confirmar para inserir.',
              async () => {
                await insereParametros();
              }, () => {}, false, true, 'Confirmar');
          } else {
            $.LoadingOverlay('hide');
          }
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível inserir os parâmetros padrões! Verifique e tente novamente.');
          $.LoadingOverlay('hide');
        };
      };

      $('#tabelaSisplanFiscal270').on('focusin', '.param270Fis', function() {
        $(this).val($(this).val().trim());
        const inputId = $(this).attr('id').slice(11);
        selecionaAjudaFiscal('tabelaAjudaSisplanFiscal270', inputId);
      });

      $('#tabelaSisplanFiscal280').on('focusin', '.param280Fis', function() {
        $(this).val($(this).val().trim());
        const inputId = $(this).attr('id').slice(11);
        selecionaAjudaFiscal('tabelaAjudaSisplanFiscal280', inputId);
      });

      $('#tabelaSisplanFiscal670').on('focusin', '.param670Fis', function() {
        $(this).val($(this).val().trim());
        const inputId = $(this).attr('id').slice(11);
        selecionaAjudaFiscal('tabelaAjudaSisplanFiscal670', inputId);
      });

      function selecionaAjudaFiscal(tabela, posicao) {
        const dados = $(`#${tabela}`).DataTable().rows().data().toArray();
        const indice = dados.findIndex((item) =>
          posicao >= item.POS_PARAM && posicao <= item.POS_PARAM + item.TAM_PARAM - 1
        );

        if (indice == -1) {
          return;
        }

        let linhaDesejada = $(`#${tabela} tbody tr`).eq(indice);
        $(`#${tabela}`).DataTable().$('tr.selected').removeClass('selected');
        linhaDesejada.addClass('selected');
        $(`#${tabela}`).DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));
      }

      async function buscaAjudaSisplanFiscal() {
        try {
          let response = await requisicao('GET',
            '/Sisplan/Funcoes/V1/pesquisa?',
            `JSON={ 
            "tabela":"AJUDA", 
            "camposSelect":["AJUDA.POS_PARAM, AJUDA.TAM_PARAM, AJUDA.TEXTO OBS"], 
            "where": ["AJUDA.COD_PARAM IN (270) AND TIPO_PARAM = 'SIS'"],
            "orderBy":["AJUDA.POS_PARAM"]
          }`, null);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status !== 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          if (jsonStr.RESULT[0].length > 0) {
            let dataSetCols = [];
            let keys = Object.keys(jsonStr.RESULT[0][0]);

            keys.forEach((k) => {
              dataSetCols.push({
                title: k,
                data: k,
              });
            });
            criaDataTablePadrao('#tabelaAjudaSisplanFiscal270', false, false, false, false, true, true, '200px', jsonStr.RESULT[0], dataSetCols);
            $("#tabelaAjudaSisplanFiscal270").DataTable().columns.adjust().draw(false);
          }

          response = await requisicao('GET',
            '/Sisplan/Funcoes/V1/pesquisa?',
            `JSON={ 
            "tabela":"AJUDA", 
            "camposSelect":["AJUDA.POS_PARAM, AJUDA.TAM_PARAM, AJUDA.TEXTO OBS"], 
            "where": ["AJUDA.COD_PARAM IN (280) AND TIPO_PARAM = 'SIS'"],
            "orderBy":["AJUDA.POS_PARAM"]
          }`, null);

          if (!response) {
            return;
          }

          jsonStr = await response.json();
          if (response.status !== 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          if (jsonStr.RESULT[0].length > 0) {
            let dataSetCols = [];
            let keys = Object.keys(jsonStr.RESULT[0][0]);

            keys.forEach((k) => {
              dataSetCols.push({
                title: k,
                data: k,
              });
            });
            criaDataTablePadrao('#tabelaAjudaSisplanFiscal280', false, false, false, false, true, true, '200px', jsonStr.RESULT[0], dataSetCols);
            $("#tabelaAjudaSisplanFiscal280").DataTable().columns.adjust().draw(false);
          }

          response = await requisicao('GET',
            '/Sisplan/Funcoes/V1/pesquisa?',
            `JSON={ 
            "tabela":"AJUDA", 
            "camposSelect":["AJUDA.POS_PARAM, AJUDA.TAM_PARAM, AJUDA.TEXTO OBS"], 
            "where": ["AJUDA.COD_PARAM IN (670) AND TIPO_PARAM = 'SIS'"],
            "orderBy":["AJUDA.POS_PARAM"]
          }`, null);

          if (!response) {
            return;
          }

          jsonStr = await response.json();
          if (response.status !== 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          if (jsonStr.RESULT[0].length > 0) {
            let dataSetCols = [];
            let keys = Object.keys(jsonStr.RESULT[0][0]);

            keys.forEach((k) => {
              dataSetCols.push({
                title: k,
                data: k,
              });
            });
            criaDataTablePadrao('#tabelaAjudaSisplanFiscal670', false, false, false, false, true, true, '200px', jsonStr.RESULT[0], dataSetCols);
            $("#tabelaAjudaSisplanFiscal670").DataTable().columns.adjust().draw(false);
          }
        } catch (error) {
          console.log('Erro ao buscar o ajuda do sisplan fiscal: ' + error);
        }
      }

      async function salvaParametroSisplanFiscal() {
        let param270 = '';
        let param270_Orig = "";
        let param280 = '';
        let param280_Orig = "";
        let param670 = '';
        let param670_Orig = "";
        for (let i = 1; i <= 100; i++) {
          param270 += $(`#param270Fis${i}`).val() == '' ? ' ' : $(`#param270Fis${i}`).val();
          param270_Orig += $(`#param270Fis${i}`).attr("valorOrig") == '' ? ' ' : $(`#param270Fis${i}`).attr("valorOrig");

          param280 += $(`#param280Fis${i}`).val() == '' ? ' ' : $(`#param280Fis${i}`).val();
          param280_Orig += $(`#param280Fis${i}`).attr("valorOrig") == '' ? ' ' : $(`#param280Fis${i}`).attr("valorOrig");

          param670 += $(`#param670Fis${i}`).val() == '' ? ' ' : $(`#param670Fis${i}`).val();
          param670_Orig += $(`#param670Fis${i}`).attr("valorOrig") == '' ? ' ' : $(`#param670Fis${i}`).attr("valorOrig");
        }

        const parametro = [];

        if (param270 != param270_Orig) {
          parametro.push({
            Tipo: "SIS",
            Posicao: 270,
            Valor: param270
          });
        }

        if (param280 != param280_Orig) {
          parametro.push({
            Tipo: "SIS",
            Posicao: 280,
            Valor: param280
          })
        }

        if (param670 != param670_Orig) {
          parametro.push({
            Tipo: "SIS",
            Posicao: 670,
            Valor: param670
          })
        }

        const parametros = {
          parametros: parametro
        };

        let response = await requisicao(
          "POST",
          "/Sisplan/Parametro/v1/sisplanfiscal?",
          "",
          `JSON=${encodeURIComponent(JSON.stringify(parametros))}`,
          30000
        );

        if (!response) {
          msgErro("Não foi possível salvar os parametros do Sisplan Fiscal.");
        }

        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
        }
      }

      $('#collapse-paramSisplanFiscal1').on("shown.bs.collapse", function(e) {
        $("#tabelaAjudaSisplanFiscal270").DataTable().columns.adjust().draw(false);
      })

      $('#collapse-paramSisplanFiscal2').on("shown.bs.collapse", function(e) {
        $("#tabelaAjudaSisplanFiscal280").DataTable().columns.adjust().draw(false);
      })

      $('#collapse-paramSisplanFiscal3').on("shown.bs.collapse", function(e) {
        $("#tabelaAjudaSisplanFiscal670").DataTable().columns.adjust().draw(false);
      })

      await buscaParamentrosFaccao();

      async function buscaParamentrosFaccao() {
        let param310 = '';
        try {
          let response = await requisicao('GET',
            '/Sisplan/Funcoes/V1/pesquisa?',
            `JSON={ 
              "tabela":"EMP_PARAM", 
              "camposSelect":["EMP_PARAM.VALOR, EMP_PARAM.CODIGO"], 
              "where": ["EMP_PARAM.EMPRESA = '${getCookie('empresa').substring(1)}' AND EMP_PARAM.TIPO = 'FAC' AND EMP_PARAM.CODIGO IN ('310', '500')"]
            }`, null);

          if (!response) {
            return;
          }

          const jsonStr = await response.json();
          if (response.status !== 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          if (jsonStr.RESULT[0].length > 0) {
            param310 = jsonStr.RESULT[0][0].CODIGO == '310' ? jsonStr.RESULT[0][0].VALOR : jsonStr.RESULT[0][1].VALOR;
            param500 = jsonStr.RESULT[0][0].CODIGO == '500' ? jsonStr.RESULT[0][0].VALOR : jsonStr.RESULT[0][1].VALOR;
          }

          const dataSetColsModal = [];
          for (let i = 1; i <= 100; i++) {
            dataSetColsModal.push({
              title: `${i}`,
              data: `${i}`,
            });
          }

          let rowData310 = [{}];
          let rowData500 = [{}];
          for (let i = 1; i <= 100; i++) {
            const input310 = `<input type="text" class="input-default focus form-control param310Fac" id="param310Fac${i}" maxlength="1" valorOrig="${param310[i - 1] != undefined ? param310[i - 1] : ''}" value="${param310[i - 1] != undefined ? param310[i - 1] : ''}">`
            rowData310[0][i] = input310;
            const input500 = `<input type="text" class="input-default focus form-control param500Fac" id="param500Fac${i}" maxlength="1" valorOrig="${param500[i - 1] != undefined ? param500[i - 1] : ''}" value="${param500[i - 1] != undefined ? param500[i - 1] : ''}">`
            rowData500[0][i] = input500;
          }

          criaDataTablePadrao('#tabelaFaccao310', false, false, false, false, true, true, '100px', rowData310, dataSetColsModal);
          criaDataTablePadrao('#tabelaFaccao500', false, false, false, false, true, true, '100px', rowData500, dataSetColsModal);
          await buscaAjudaFaccao();
        } catch (error) {
          console.log('Erro ao buscar os parâmetros da facção: ' + error);
        }
      }

      $('#tabelaFaccao310').on('focusin', '.param310Fac', function() {
        const inputId = $(this).attr('id').slice(11);
        selecionaAjudaFiscal('tabelaAjudaFaccao310', inputId);
      });

      $('#tabelaFaccao500').on('focusin', '.param500Fac', function() {
        const inputId = $(this).attr('id').slice(11);
        selecionaAjudaFiscal('tabelaAjudaFaccao500', inputId);
      });

      async function buscaAjudaFaccao() {
        try {
          let response = await requisicao('GET',
            '/Sisplan/Funcoes/V1/pesquisa?',
            `JSON={ 
            "tabela":"AJUDA", 
            "camposSelect":["AJUDA.POS_PARAM, AJUDA.TAM_PARAM, AJUDA.TEXTO OBS"], 
            "where": ["AJUDA.COD_PARAM IN (310) AND TIPO_PARAM = 'FAC'"],
            "orderBy":["AJUDA.POS_PARAM"]
          }`, null);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status !== 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          if (jsonStr.RESULT[0].length > 0) {
            let dataSetCols = [];
            let keys = Object.keys(jsonStr.RESULT[0][0]);

            keys.forEach((k) => {
              dataSetCols.push({
                title: k,
                data: k,
              });
            });
            criaDataTablePadrao('#tabelaAjudaFaccao310', false, false, false, false, true, true, '200px', jsonStr.RESULT[0], dataSetCols);
            $("#tabelaAjudaFaccao310").DataTable().columns.adjust().draw(false);
          }

          response = await requisicao('GET',
            '/Sisplan/Funcoes/V1/pesquisa?',
            `JSON={ 
            "tabela":"AJUDA", 
            "camposSelect":["AJUDA.POS_PARAM, AJUDA.TAM_PARAM, AJUDA.TEXTO OBS"], 
            "where": ["AJUDA.COD_PARAM IN (500) AND TIPO_PARAM = 'FAC'"],
            "orderBy":["AJUDA.POS_PARAM"]
          }`, null);

          if (!response) {
            return;
          }

          jsonStr = await response.json();
          if (response.status !== 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          if (jsonStr.RESULT[0].length > 0) {
            let dataSetCols = [];
            let keys = Object.keys(jsonStr.RESULT[0][0]);

            keys.forEach((k) => {
              dataSetCols.push({
                title: k,
                data: k,
              });
            });
            criaDataTablePadrao('#tabelaAjudaFaccao500', false, false, false, false, true, true, '200px', jsonStr.RESULT[0], dataSetCols);
            $("#tabelaAjudaFaccao500").DataTable().columns.adjust().draw(false);
          }
        } catch (error) {
          console.log('Erro ao buscar o ajuda da facção: ' + error);
        }
      }

      async function salvaParametroFaccao() {
        let param310 = '';
        let param310_Orig = "";
        let param500 = '';
        let param500_Orig = "";
        for (let i = 1; i <= 100; i++) {
          param310 += $(`#param310Fac${i}`).val() == '' ? ' ' : $(`#param310Fac${i}`).val();
          param310_Orig += $(`#param310Fac${i}`).attr("valorOrig") == '' ? ' ' : $(`#param310Fac${i}`).attr("valorOrig");

          param500 += $(`#param500Fac${i}`).val() == '' ? ' ' : $(`#param500Fac${i}`).val();
          param500_Orig += $(`#param500Fac${i}`).attr("valorOrig") == '' ? ' ' : $(`#param500Fac${i}`).attr("valorOrig");
        }

        const parametro = [];

        if (param310 != param310_Orig) {
          parametro.push({
            Tipo: "FAC",
            Posicao: 310,
            Valor: param310
          });
        }

        if (param500 != param500_Orig) {
          parametro.push({
            Tipo: "FAC",
            Posicao: 500,
            Valor: param500
          })
        }

        const parametros = {
          parametros: parametro
        };

        let response = await requisicao(
          "POST",
          "/Sisplan/Parametro/v1/sisplanfiscal?",
          "",
          `JSON=${encodeURIComponent(JSON.stringify(parametros))}`,
          30000
        );

        if (!response) {
          msgErro("Não foi possível salvar os parâmetros da facção.");
        }

        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
        }
      }

      $('#collapse-paramFaccao1').on("shown.bs.collapse", function(e) {
        $("#tabelaAjudaFaccao310").DataTable().columns.adjust().draw(false);
      });

      $('#collapse-paramFaccao2').on("shown.bs.collapse", function(e) {
        $("#tabelaAjudaFaccao500").DataTable().columns.adjust().draw(false);
      });

      await buscarParametrosCustos()

      async function buscarParametrosCustos() {
        let param60 = '';
        try {
          let response = await requisicao('GET',
            '/Sisplan/Funcoes/V1/pesquisa?',
            `JSON={ 
              "tabela":"EMP_PARAM", 
              "camposSelect":["EMP_PARAM.VALOR, EMP_PARAM.CODIGO"], 
              "where": ["EMP_PARAM.EMPRESA = '${getCookie('empresa').substring(1)}' AND EMP_PARAM.TIPO = 'CUS' AND EMP_PARAM.CODIGO IN ('60')"]
            }`, null);

          if (!response) {
            return;
          }

          const jsonStr = await response.json();
          if (response.status !== 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          if (jsonStr.RESULT[0].length > 0) {
            param60 = jsonStr.RESULT[0][0].CODIGO == '60' ? jsonStr.RESULT[0][0].VALOR : jsonStr.RESULT[0][1].VALOR;
          }

          const dataSetColsModal = [];
          for (let i = 1; i <= 100; i++) {
            dataSetColsModal.push({
              title: `${i}`,
              data: `${i}`,
            });
          }

          let rowData60 = [{}];
          for (let i = 1; i <= 100; i++) {
            const input60 = `<input type="text" class="input-default focus form-control param60Cus" id="param60Cus${i}" maxlength="1" valorOrig="${param60[i - 1] != undefined ? param60[i - 1] : ''}" value="${param60[i - 1] != undefined ? param60[i - 1] : ''}">`
            rowData60[0][i] = input60;
          }

          criaDataTablePadrao('#tabelaCustos60', false, false, false, false, true, true, '100px', rowData60, dataSetColsModal);
          await buscaAjudaCustos();
        } catch (error) {
          console.log('Erro ao buscar os parâmetros dos custos: ' + error);
        }
      }

      $('#tabelaCustos60').on('focusin', '.param60Cus', function() {
        const inputId = $(this).attr('id').slice(11);
        selecionaAjudaFiscal('tabelaAjudaCustos60', inputId);
      });

      async function buscaAjudaCustos() {
        try {
          let response = await requisicao('GET',
            '/Sisplan/Funcoes/V1/pesquisa?',
            `JSON={ 
            "tabela":"AJUDA", 
            "camposSelect":["AJUDA.POS_PARAM, AJUDA.TAM_PARAM, AJUDA.TEXTO OBS"], 
            "where": ["AJUDA.COD_PARAM IN (60) AND TIPO_PARAM = 'CUS'"],
            "orderBy":["AJUDA.POS_PARAM"]
          }`, null);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status !== 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          if (jsonStr.RESULT[0].length > 0) {
            let dataSetCols = [];
            let keys = Object.keys(jsonStr.RESULT[0][0]);

            keys.forEach((k) => {
              dataSetCols.push({
                title: k,
                data: k,
              });
            });
            criaDataTablePadrao('#tabelaAjudaCustos60', false, false, false, false, true, true, '200px', jsonStr.RESULT[0], dataSetCols);
            $("#tabelaAjudaCustos60").DataTable().columns.adjust().draw(false);
          }
        } catch (error) {
          console.log('Erro ao buscar o ajuda dos custos: ' + error);
        }
      }

      async function salvaParametrosCustos() {
        let param60 = '';
        let param60_Orig = "";
        for (let i = 1; i <= 100; i++) {
          param60 += $(`#param60Cus${i}`).val() == '' ? ' ' : $(`#param60Cus${i}`).val();
          param60_Orig += $(`#param60Cus${i}`).attr("valorOrig") == '' ? ' ' : $(`#param60Cus${i}`).attr("valorOrig");
        }

        const parametro = [];

        if (param60 != param60_Orig) {
          parametro.push({
            Tipo: "CUS",
            Posicao: 60,
            Valor: param60
          });
        }

        const parametros = {
          parametros: parametro
        };

        let response = await requisicao(
          "POST",
          "/Sisplan/Parametro/v1/sisplanfiscal?",
          "",
          `JSON=${encodeURIComponent(JSON.stringify(parametros))}`,
          30000
        );

        if (!response) {
          msgErro("Não foi possível salvar os parâmetros dos custos.");
        }

        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
        }
      }

      $('#collapse-param60Custos').on("shown.bs.collapse", function(e) {
        $("#tabelaAjudaCustos60").DataTable().columns.adjust().draw(false);
      });

      const parametrosOrig = buscaParamOrig();

      //salva parametros
      $('#btnSalvar').on('click', async function() {
        try {
          $.LoadingOverlay("show");

          const parametrosObj = [];
          const parametrosVendaOrig = parametrosOrig.filter(filter => filter.TIPO == 'VENDA');
          const parametrosReceberOrig = parametrosOrig.filter(filter => filter.TIPO == 'RECEBER');
          const parametrosFaturamentoOrig = parametrosOrig.filter(filter => filter.TIPO == 'FATURAMENTO');
          const parametrosProdutoOrig = parametrosOrig.filter(filter => filter.TIPO == 'PRODUTO');
          const parametrosMaterialOrig = parametrosOrig.filter(filter => filter.TIPO == 'MATERIAL');
          const parametrosPedidoOrig = parametrosOrig.filter(filter => filter.TIPO == 'PEDIDO');
          const parametrosExpedicaoOrig = parametrosOrig.filter(filter => filter.TIPO == 'EXPEDICAO');
          const parametrosSistemaOrig = parametrosOrig.filter(filter => filter.TIPO == 'SISTEMA');
          const parametrosEntidadeOrig = parametrosOrig.filter(filter => filter.TIPO == 'ENTIDADE');
          const parametrosPedidoB2BOrig = parametrosOrig.filter(filter => filter.TIPO == 'PEDIDOB2B');
          const parametrosEscrituralOrig = parametrosOrig.filter(filter => filter.TIPO == 'ESCRITURAL');
          const parametrosOrdemProducaoOrig = parametrosOrig.filter(filter => filter.TIPO == 'ORDEMPRODUCAO');
          const parametrosContabilOrig = parametrosOrig.filter(filter => filter.TIPO == 'CONTABIL');
          const parametrosComprasOrig = parametrosOrig.filter(filter => filter.TIPO == 'COMPRAS');
          const parametrosCustosOrig = parametrosOrig.filter(filter => filter.TIPO == 'CUSTOS')

          for (let i = 0; i < $('.parametroVenda').length; i++) {
            if (parametrosVendaOrig[i].VALOR != $($(`.parametroVenda`)[i]).val()) {
              const objeto = {
                TIPO: 'VENDA',
                POSICAO: i,
                VALOR: $($(`.parametroVenda`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroVenda`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroVenda`)[i])[0][$($(`.parametroVenda`)[i]).val()].text : '',
                VALOR_OLD: parametrosVendaOrig[i].VALOR,
                DESCRICAO_OLD: parametrosVendaOrig[i].DESCRICAO,
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroReceber').length; i++) {
            if (parametrosReceberOrig[i].VALOR != $($(`.parametroReceber`)[i]).val()) {
              const objeto = {
                TIPO: 'RECEBER',
                POSICAO: i,
                VALOR: $($(`.parametroReceber`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroReceber`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroReceber`)[i])[0][$($(`.parametroReceber`)[i]).val()]?.text : '',
                VALOR_OLD: parametrosReceberOrig[i].VALOR,
                DESCRICAO_OLD: parametrosReceberOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroFaturamento').length; i++) {
            if (parametrosFaturamentoOrig[i].VALOR != $($(`.parametroFaturamento`)[i]).val()) {
              const objeto = {
                TIPO: 'FATURAMENTO',
                POSICAO: i,
                VALOR: $($(`.parametroFaturamento`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroFaturamento`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroFaturamento`)[i])[0][$($(`.parametroFaturamento`)[i]).val()].text : '',
                VALOR_OLD: parametrosFaturamentoOrig[i].VALOR,
                DESCRICAO_OLD: parametrosFaturamentoOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroProduto').length; i++) {
            if (parametrosProdutoOrig[i].VALOR != $($(`.parametroProduto`)[i]).val()) {
              const objeto = {
                TIPO: 'PRODUTO',
                POSICAO: i,
                VALOR: $($(`.parametroProduto`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroProduto`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroProduto`)[i])[0][$($(`.parametroProduto`)[i]).val()].text : '',
                VALOR_OLD: parametrosProdutoOrig[i].VALOR,
                DESCRICAO_OLD: parametrosProdutoOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroMaterial').length; i++) {
            if (parametrosMaterialOrig[i].VALOR != $($(`.parametroMaterial`)[i]).val()) {
              const objeto = {
                TIPO: 'MATERIAL',
                POSICAO: i,
                VALOR: $($(`.parametroMaterial`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroMaterial`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroMaterial`)[i])[0][$($(`.parametroMaterial`)[i]).val()].text : '',
                VALOR_OLD: parametrosMaterialOrig[i].VALOR,
                DESCRICAO_OLD: parametrosMaterialOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroPedido').length; i++) {
            if (parametrosPedidoOrig[i].VALOR != $($(`.parametroPedido`)[i]).val()) {
              const objeto = {
                TIPO: 'PEDIDO',
                POSICAO: i,
                VALOR: $($(`.parametroPedido`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroPedido`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroPedido`)[i])[0][$($(`.parametroPedido`)[i]).val()].text : '',
                VALOR_OLD: parametrosPedidoOrig[i].VALOR,
                DESCRICAO_OLD: parametrosPedidoOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroExpedicao').length; i++) {
            if (parametrosExpedicaoOrig[i].VALOR != $($(`.parametroExpedicao`)[i]).val()) {
              const objeto = {
                TIPO: 'EXPEDICAO',
                POSICAO: i,
                VALOR: $($(`.parametroExpedicao`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroExpedicao`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroExpedicao`)[i])[0][$($(`.parametroExpedicao`)[i]).val()].text : '',
                VALOR_OLD: parametrosExpedicaoOrig[i].VALOR,
                DESCRICAO_OLD: parametrosExpedicaoOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroSistema').length; i++) {
            if (parametrosSistemaOrig[i].VALOR != $($(`.parametroSistema`)[i]).val()) {
              const objeto = {
                TIPO: 'SISTEMA',
                POSICAO: i,
                VALOR: $($(`.parametroSistema`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroSistema`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroSistema`)[i])[0][$($(`.parametroSistema`)[i]).val()].text : '',
                VALOR_OLD: parametrosSistemaOrig[i].VALOR,
                DESCRICAO_OLD: parametrosSistemaOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroEntidade').length; i++) {
            if (parametrosEntidadeOrig[i].VALOR != $($(`.parametroEntidade`)[i]).val()) {
              const objeto = {
                TIPO: 'ENTIDADE',
                POSICAO: i,
                VALOR: $($(`.parametroEntidade`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroEntidade`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroEntidade`)[i])[0][$($(`.parametroEntidade`)[i]).val()].text : '',
                VALOR_OLD: parametrosEntidadeOrig[i].VALOR,
                DESCRICAO_OLD: parametrosEntidadeOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroPedidob2b').length; i++) {
            if (parametrosPedidoB2BOrig[i].VALOR != $($(`.parametroPedidob2b`)[i]).val()) {
              const objeto = {
                TIPO: 'PEDIDOB2B',
                POSICAO: i,
                VALOR: $($(`.parametroPedidob2b`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroPedidob2b`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroPedidob2b`)[i])[0][$($(`.parametroPedidob2b`)[i]).val()].text : '',
                VALOR_OLD: parametrosPedidoB2BOrig[i].VALOR,
                DESCRICAO_OLD: parametrosPedidoB2BOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroEscritural').length; i++) {
            if (parametrosEscrituralOrig[i].VALOR != $($(`.parametroEscritural`)[i]).val()) {
              const objeto = {
                TIPO: 'ESCRITURAL',
                POSICAO: i,
                VALOR: $($(`.parametroEscritural`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroEscritural`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroEscritural`)[i])[0][$($(`.parametroEscritural`)[i]).val()].text : '',
                VALOR_OLD: parametrosEscrituralOrig[i].VALOR,
                DESCRICAO_OLD: parametrosEscrituralOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroOrdemProducao').length; i++) {
            if (parametrosOrdemProducaoOrig[i].VALOR != $($(`.parametroOrdemProducao`)[i]).val()) {
              const objeto = {
                TIPO: 'ORDEMPRODUCAO',
                POSICAO: i,
                VALOR: $($(`.parametroOrdemProducao`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroOrdemProducao`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroOrdemProducao`)[i])[0][$($(`.parametroOrdemProducao`)[i]).val()].text : '',
                VALOR_OLD: parametrosOrdemProducaoOrig[i].VALOR,
                DESCRICAO_OLD: parametrosOrdemProducaoOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroContabil').length; i++) {
            if (parametrosContabilOrig[i].VALOR != $($(`.parametroContabil`)[i]).val()) {
              const objeto = {
                TIPO: 'CONTABIL',
                POSICAO: i,
                VALOR: $($(`.parametroContabil`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroContabil`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroContabil`)[i])[0][$($(`.parametroContabil`)[i]).val()].text : '',
                VALOR_OLD: parametrosContabilOrig[i].VALOR,
                DESCRICAO_OLD: parametrosContabilOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroCompras').length; i++) {
            if (parametrosComprasOrig[i].VALOR != $($(`.parametroCompras`)[i]).val()) {
              const objeto = {
                TIPO: 'COMPRAS',
                POSICAO: i,
                VALOR: $($(`.parametroCompras`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroCompras`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroCompras`)[i])[0][$($(`.parametroCompras`)[i]).val()].text : '',
                VALOR_OLD: parametrosComprasOrig[i].VALOR,
                DESCRICAO_OLD: parametrosComprasOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          for (let i = 0; i < $('.parametroCustos').length; i++) {
            if (parametrosCustosOrig[i].VALOR != $($(`.parametroCustos`)[i]).val()) {
              const objeto = {
                TIPO: 'CUSTOS',
                POSICAO: i,
                VALOR: $($(`.parametroCustos`)[i]).val(),
                EMP_ID: empId,
                DESCRICAO: $($(`.parametroCustos`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroCustos`)[i])[0][$($(`.parametroCustos`)[i]).val()].text : '',
                VALOR_OLD: parametrosCustosOrig[i].VALOR,
                DESCRICAO_OLD: parametrosCustosOrig[i].DESCRICAO
              };
              parametrosObj.push(objeto);
            }
          }

          const parametros = {
            parametros: parametrosObj
          };

          try {
            await SalvaParametro(parametros);
            await salvaParametroSisplanFiscal();
            await salvaParametroFaccao();
            await criaMensagemSucesso('Parâmetros gravados com sucesso.', () => {
              window.location.reload()
            });
          } catch (error) {
            msgErro(error);
            console.error(error);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      });

      function buscaParamOrig() {
        let parametrosObj = [];

        for (let i = 0; i < $('.parametroVenda').length; i++) {
          const objeto = {
            TIPO: 'VENDA',
            POSICAO: i,
            VALOR: $($(`.parametroVenda`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroVenda`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroVenda`)[i])[0][$($(`.parametroVenda`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroReceber').length; i++) {
          const objeto = {
            TIPO: 'RECEBER',
            POSICAO: i,
            VALOR: $($(`.parametroReceber`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroReceber`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroReceber`)[i])[0][$($(`.parametroReceber`)[i]).val()]?.text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroFaturamento').length; i++) {
          const objeto = {
            TIPO: 'FATURAMENTO',
            POSICAO: i,
            VALOR: $($(`.parametroFaturamento`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroFaturamento`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroFaturamento`)[i])[0][$($(`.parametroFaturamento`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroProduto').length; i++) {
          const objeto = {
            TIPO: 'PRODUTO',
            POSICAO: i,
            VALOR: $($(`.parametroProduto`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroProduto`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroProduto`)[i])[0][$($(`.parametroProduto`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroMaterial').length; i++) {
          const objeto = {
            TIPO: 'MATERIAL',
            POSICAO: i,
            VALOR: $($(`.parametroMaterial`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroMaterial`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroMaterial`)[i])[0][$($(`.parametroMaterial`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroPedido').length; i++) {
          const objeto = {
            TIPO: 'PEDIDO',
            POSICAO: i,
            VALOR: $($(`.parametroPedido`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroPedido`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroPedido`)[i])[0][$($(`.parametroPedido`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroExpedicao').length; i++) {
          const objeto = {
            TIPO: 'EXPEDICAO',
            POSICAO: i,
            VALOR: $($(`.parametroExpedicao`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroExpedicao`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroExpedicao`)[i])[0][$($(`.parametroExpedicao`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroSistema').length; i++) {
          const objeto = {
            TIPO: 'SISTEMA',
            POSICAO: i,
            VALOR: $($(`.parametroSistema`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroSistema`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroSistema`)[i])[0][$($(`.parametroSistema`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroEntidade').length; i++) {
          const objeto = {
            TIPO: 'ENTIDADE',
            POSICAO: i,
            VALOR: $($(`.parametroEntidade`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroEntidade`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroEntidade`)[i])[0][$($(`.parametroEntidade`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroPedidob2b').length; i++) {
          const objeto = {
            TIPO: 'PEDIDOB2B',
            POSICAO: i,
            VALOR: $($(`.parametroPedidob2b`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroPedidob2b`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroPedidob2b`)[i])[0][$($(`.parametroPedidob2b`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroEscritural').length; i++) {
          const objeto = {
            TIPO: 'ESCRITURAL',
            POSICAO: i,
            VALOR: $($(`.parametroEscritural`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroEscritural`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroEscritural`)[i])[0][$($(`.parametroEscritural`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroOrdemProducao').length; i++) {
          const objeto = {
            TIPO: 'ORDEMPRODUCAO',
            POSICAO: i,
            VALOR: $($(`.parametroOrdemProducao`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroOrdemProducao`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroOrdemProducao`)[i])[0][$($(`.parametroOrdemProducao`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroContabil').length; i++) {
          const objeto = {
            TIPO: 'CONTABIL',
            POSICAO: i,
            VALOR: $($(`.parametroContabil`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroContabil`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroContabil`)[i])[0][$($(`.parametroContabil`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroCompras').length; i++) {
          const objeto = {
            TIPO: 'COMPRAS',
            POSICAO: i,
            VALOR: $($(`.parametroCompras`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroCompras`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroCompras`)[i])[0][$($(`.parametroCompras`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        for (let i = 0; i < $('.parametroCustos').length; i++) {
          const objeto = {
            TIPO: 'CUSTOS',
            POSICAO: i,
            VALOR: $($(`.parametroCustos`)[i]).val(),
            EMP_ID: empId,
            DESCRICAO: $($(`.parametroCustos`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroCustos`)[i])[0][$($(`.parametroCustos`)[i]).val()].text : ''
          };
          parametrosObj.push(objeto);
        }

        return parametrosObj;
      }

      function adicionaBotaoLog() {
        $($(".card-header label")).append('<button type="button" title="Logs" class="btn btn-info btn-sm ml-2 log" style="color: white;"> <i class="fas fa-question-circle"></i></button>');
        $($(".card-header label")).css("width", "auto");
      }

      function adicionaBotaoAplicarTodasEmpresas() {
        const listaParams = $(".card-header label").filter(function() {
          return $(this).closest('#loja_sisplanFiscal').length === 0;
        }).toArray();

        for (let i = 0; i < listaParams.length; i++) {
          const element = listaParams[i];
          $(element).append('<button type="button" title="Aplicar parâmetro em outras empresas" class="btn btn-info btn-sm ml-2 aplicarTodasEmpresas" style="color: white;"> <i class="fas fa-check-circle"></i></button>');
          $(element).css("width", "auto");
        }
      }

      $(".aplicarTodasEmpresas").on("click", async function(e) {
        e.stopPropagation();
        $.LoadingOverlay("show");
        const labelParametro = $(this).parent().text().trim();
        const objetoLogsParametro = retornaObjetoLogsParametro(labelParametro);
        try {
          console.log(objetoLogsParametro);
          carregaTodasEmpresasIndividual(objetoLogsParametro);
        } finally {
          $.LoadingOverlay("hide");
        }
      })

      $(".log").on("click", async function(e) {
        e.stopPropagation();
        $.LoadingOverlay("show");
        const labelParametro = $(this).parent().text().trim();
        const objetoLogsParametro = retornaObjetoLogsParametro(labelParametro);
        try {
          await consultaLogsParametro(objetoLogsParametro);
          $("#modalLogsParametro").modal("show");
        } finally {
          $.LoadingOverlay("hide");
        }
      })

      function retornaObjetoLogsParametro(labelParametro) {
        const objetoLogsParametro = {};
        const tipo = $(".divParametros").children('.active').attr('tipoParametro');

        if (validaParametroERP(labelParametro)) {
          objetoLogsParametro.TIPO = tipo;
          objetoLogsParametro.POSICAO = labelParametro.split("-")[2].trim();
          objetoLogsParametro.PARAMETRO_ERP = labelParametro.split("-")[1].trim();
        } else {
          objetoLogsParametro.TIPO = tipo;
          objetoLogsParametro.POSICAO = parseInt(labelParametro.split(".")[0]) - (tipo != "ORDEMPRODUCAO" ? 1 : 3);
          objetoLogsParametro.PARAMETRO_ERP = "";
        }
        return objetoLogsParametro;
      }

      function validaParametroERP(labelParametro) {
        const validator = labelParametro.split("-");
        if (validator.length > 1 && !isNaN(parseInt(validator[validator.length - 1].trim()))) {
          return true;
        }
        return false;
      }

      async function consultaLogsParametro(objetoLogsParametro) {
        try {

          const response = await requisicao('GET', '/sisplan/parametro/V1/consultalogsparametro?', `TIPO_PARAMETRO=${objetoLogsParametro.TIPO}&POSICAO=${objetoLogsParametro.TIPO == 'SISPLANFISCAL' ||objetoLogsParametro.TIPO == 'ORDEMPRODUCAO' ? objetoLogsParametro.POSICAO : objetoLogsParametro.POSICAO+1}&PARAMETRO_ERP=${objetoLogsParametro.PARAMETRO_ERP}`, undefined, 60000);

          if (!response) {
            throw new Error("Não foi possível consultar os logs do parâmetro!");
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            throw new Error(jsonStr.mensagem);
          }

          if (jsonStr.length > 0) {
            carregaLogsModal(jsonStr);
          } else {
            limpaLogsModal();
          }

        } catch (error) {
          console.error(error);
          msgErro(error.message);
        }
      }

      $("#btnFecharModalLogsParametro").on("click", function() {
        $("#modalLogsParametro").modal("hide");
      })

      $("#modalLogsParametro").on("shown.bs.modal", function() {
        if ($.fn.DataTable.isDataTable('#tabelaLogsParametro')) {
          $('#tabelaLogsParametro').DataTable().columns.adjust().draw(false);
        }
      })

      function carregaLogsModal(objeto) {

        function formatarData(data) {
          const date = new Date(data);
          const dataFormatada = ('0' + date.getDate()).slice(-2) + '/' + ('0' + (date.getMonth() + 1)).slice(-2) + '/' + date.getFullYear() + ' ' + ('0' + date.getHours()).slice(-2) + ':' + ('0' + date.getMinutes()).slice(-2) + ':' + ('0' + date.getSeconds()).slice(-2);
          return dataFormatada;
        }

        limpaLogsModal();
        const keys = Object.keys(objeto[0]);
        const dataSetCols = [];

        for (var k in keys) {
          dataSetCols.push({
            'title': keys[k].toUpperCase(),
            'data': keys[k]
          });
        };

        dataSetCols[0].render = function(data, type, row, meta) {
          return formatarData(data);
        }

        criaDataTablePadrao('#tabelaLogsParametro', false, false, false, false, true, false, false, objeto, dataSetCols);

      }

      function limpaLogsModal() {
        if ($.fn.DataTable.isDataTable('#tabelaLogsParametro')) {
          $("#tabelaLogsParametro").DataTable().data().clear().draw(false);
        }
      }


      async function carregaTodasEmpresas() {
        try {
          $('#modal-exportar-body').html('');
          const dadosSelect = {
            tabela: `EMPRESA`,
            camposSelect: ['EMP_ID', 'EMP_NOME', "REPLACE(EMP_PAT,'_','') EMPRESA"],
            where: [`EMP_ID <> ${getCookie('emp_id')}`],
            orderBy: ['EMP_ID']
          };
          const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
          if (!retornoSelect) {
            return;
          }
          if (retornoSelect && retornoSelect.length > 0) {
            $('#modal-exportar-parametros').modal('show');
            $('#modal-exportar-body').html('');
            for (let index = 0; index < retornoSelect.length; index++) {
              const empresa = retornoSelect[index];
              $('#modal-exportar-body').append(
                `<div class="form-check icheck-primary" style ="margin-left: 0px !important">
                    <input id="cbEmpresa-${empresa.EMP_ID}" data-emp-id="${empresa.EMP_ID}" class="form-check-input empresa_selecionada" type="checkbox" ${getCookie('emp_id') == empresa.EMP_ID ? 'checked' : ''}> 
                    <label for="cbEmpresa-${empresa.EMP_ID}">${`${empresa.EMPRESA} - ${empresa.EMP_NOME}`}</label>
                 </div>`
              );
            }
            $('#cbTodasAsEmpresas').off();
            $('#cbTodasAsEmpresas').on('click', function() {
              $('.empresa_selecionada').toArray().map(input => {
                $(`#${input.id}`).prop('checked', $('#cbTodasAsEmpresas').prop('checked'));
              });
            });
          }


        } catch (error) {
          console.error(error);
        }
      }

      async function carregaTodasEmpresasIndividual(objetoParametro) {
        try {
          $('#modal-exportar-individual-body').html('');
          const dadosSelect = {
            tabela: `EMPRESA`,
            camposSelect: ['EMP_ID', 'EMP_NOME', "REPLACE(EMP_PAT,'_','') EMPRESA"],
            where: [`EMP_ID <> ${getCookie('emp_id')}`],
            orderBy: ['EMP_ID']
          };
          const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
          if (!retornoSelect) {
            return;
          }
          if (retornoSelect && retornoSelect.length > 0) {
            $('#modal-exportar-parametros-individual').modal('show');
            $('#modal-exportar-individual-body').html('');
            $('#modal-exportar-individual-body').attr('data-param-tipo', objetoParametro.TIPO);
            $('#modal-exportar-individual-body').attr('data-param-posicao', objetoParametro.POSICAO);
            for (let index = 0; index < retornoSelect.length; index++) {
              const empresa = retornoSelect[index];
              $('#modal-exportar-individual-body').append(
                `<div class="form-check icheck-primary" style ="margin-left: 0px !important">
                    <input id="cbEmpresaIndividual-${empresa.EMP_ID}" data-emp-id="${empresa.EMP_ID}" class="form-check-input empresa_selecionada_individual" type="checkbox" ${getCookie('emp_id') == empresa.EMP_ID ? 'checked' : ''}> 
                    <label for="cbEmpresaIndividual-${empresa.EMP_ID}">${`${empresa.EMPRESA} - ${empresa.EMP_NOME}`}</label>
                 </div>`
              );
            }
            $('#cbTodasAsEmpresasIndividual').off();
            $('#cbTodasAsEmpresasIndividual').on('click', function() {
              $('.empresa_selecionada_individual').toArray().map(input => {
                $(`#${input.id}`).prop('checked', $('#cbTodasAsEmpresasIndividual').prop('checked'));
              });
            });
          }


        } catch (error) {
          console.error(error);
        }
      }


      $('#btn-exportar').off();
      $('#btn-exportar').on('click', async function() {

        await carregaTodasEmpresas();
        // busca empresas.
        $('#modal-exportar-parametros').modal('show');
      });

      $('#btn-confirmar-exportacao').off();
      $('#btn-confirmar-exportacao').on('click', function() {
        const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : []

        if (empresasFiltradas.length == 0) {
          msgAlerta('Nenhuma empresa selecionada, verifique.');
          return;
        }

        msgAlerta(`Tem certeza que deseja exportar os parametros atuais para as empresas selecionadas? Isso irá sobrepor os parametros dessas empresas...`, async () => {
          const obj = {
            empresas: empresasFiltradas
          };

          try {
            const response = await requisicao("POST", "/sisplan/parametro/V1/exportarparametros?", `JSON=${JSON.stringify(obj)}&EMP_ID=${getCookie('emp_id')}`, "", 300000);

            if (!response) {
              throw msgAlerta("Não foi possível exportar os parametros.");
            }

            if (response.status != 200) {
              throw msgAlerta("Não foi possível exportar os parametros.");
            }

            // criaMensagemSucesso("Desdobramento do lote gravado com sucesso", () => { window.location.reload(); });

            criaMensagemSucesso("Exportação efetuada com sucesso", async () => {
              $('#modal-exportar-parametros').modal('hide');
            });

          } catch (error) {
            console.error(error);
          }
        });
      });


      $('#btn-confirmar-exportacao-individual').off();
      $('#btn-confirmar-exportacao-individual').on('click', function() {
        const empresasFiltradas = $(".empresa_selecionada_individual:checked").toArray().length > 0 ? $(".empresa_selecionada_individual:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : []

        if (empresasFiltradas.length == 0) {
          msgAlerta('Nenhuma empresa selecionada, verifique.');
          return;
        }

        msgAlerta(`Tem certeza que deseja aplicar o parametro atual nas empresas selecionadas? Isso irá sobrepor os parametros dessas empresas...`, async () => {
          const obj = {
            empresas: empresasFiltradas,
            parametro_tipo: $('#modal-exportar-individual-body').attr('data-param-tipo'),
            parametro_posicao: $('#modal-exportar-individual-body').attr('data-param-posicao'),
            valor: ''
          };

          const tipoParametro = {
            'VENDA': '.parametroVenda',
            'ENTIDADE': '.parametroEntidade',
            'RECEBER': '.parametroReceber',
            'PRODUTO': '.parametroProduto',
            'MATERIAL': '.parametroMaterial',
            'ORDEMPRODUCAO': '.parametroOrdemProducao',
            'PEDIDO': '.parametroPedido',
            'PEDIDOB2B': '.parametroPedidob2b',
            'EXPEDICAO': '.parametroExpedicao',
            'ESCRITURAL': '.parametroEscritural',
            'CONTABIL': '.parametroContabil',
            'SISTEMA': '.parametroSistema',
            'COMPRAS': '.parametroCompras'
          }

          obj.valor = $(tipoParametro[obj.parametro_tipo]).eq(+($('#modal-exportar-individual-body').attr('data-param-posicao'))).val();

          try {
            const response = await requisicao("POST", "/sisplan/parametro/V1/exportarparametrosindividual?", `JSON=${JSON.stringify(obj)}&EMP_ID=${getCookie('emp_id')}`, "", 300000);

            if (!response) {
              throw msgAlerta("Não foi possível exportar o parametro.");
            }

            if (response.status != 200) {
              throw msgAlerta("Não foi possível exportar o parametro.");
            }

            criaMensagemSucesso("Exportação efetuada com sucesso", async () => {
              $('#modal-exportar-parametros-individual').modal('hide');
              $('#btnSalvar').trigger('click');
            });

          } catch (error) {
            console.error(error);
          }
        });
      });


    });
  </script>
</body>

</html>