$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'btnGravaEmbarque')) {
          if (pegaChave('#txtNumero') == '') {
            insereValor('#txtNumero', ' ', ' ')
          };
          $('#btnGravaEmbarque').trigger('click');
        }
      },
      onPrevious: (Element) => {
        if (Element.node.id == 'VoltarGeral') {
          $('#VoltarGeral').trigger('click');
        }
      }
    });

    driver.defineSteps([{
      element: '#btnTelaCheia',
      popover: {
        title: 'Botão para tela cheia',
        description: 'Responsável por abrir o modo tela cheia.',
        position: 'bottom'
      }
    },
    {
      element: '#txtNumero',
      popover: {
        title: 'Campo número',
        description: 'O número é gerado automaticamente ao sair do campo mas pode ser utilizado também para buscar pelos números de embarque já existentes.',
        position: 'bottom'
      }
    },
    {
      element: '#txtNota',
      popover: {
        title: 'Busca pela nota',
        description: 'Campo utilizado para fazer a pesquisa por nota. Pode ser inserida a chave direto no campo ou consultado pela fatura no botão de pesquisa ao lado',
        position: 'top'
      }
    },
    {
      element: '#btn-Nota',
      popover: {
        title: 'Botão de pesquisa de Nota',
        description: 'Botão utilizado para fazer a pesquisa das notas pelo número de fatura.',
        position: 'top'
      }
    },
    {
      element: '#btn-limpa-Nota',
      popover: {
        title: 'Botão de limpeza do campo de Nota',
        description: 'Botão utilizado para fazer a pesquisa das notas pelo número de fatura.',
        position: 'top'
      }
    },
    {
      element: '#divTabelaEmbarque',
      popover: {
        title: 'Tabela de Embarque',
        description: 'Tabela onde são visualizados as notas que constituem o embarque.',
        position: 'top'
      }
    },
    {
      element: '#divTabelaConferencia',
      popover: {
        title: 'Tabela de Conferencia',
        description: 'Tabela que permite fazer a conferencia das caixas vinculadas às faturas na expedição.',
        position: 'top'
      }
    },
    {
      element: '#txtNumCaixa',
      popover: {
        title: 'Conferencia das caixas',
        description: 'Campo resposável por realizar a conferência das caixas.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});

const columnsTabelaEmbarque = [
  { data: "FATURA", title: "Fatura" },
  { data: "SERIE", title: "Série" },
  { data: "CODCLI", title: "Codcli" },
  { data: "NOME", title: "Nome" },
  { data: "CODTRANSP", title: "Cod. Transp." },
  { data: "NOME_TRANSP", title: "Nome Transp." },
  { data: "CONFERIDO", title: "Conferido" },
  { data: "QTDE_CAIXAS", title: "Qtde Caixas" },
  { data: "PESO_BRUTO", title: "Peso Bruto" },
  { data: "VALOR", title: "Valor" },
  { data: "VOLUMES", title: "Volumes" },
  { data: "ENDERECO", title: "Endereço" },
  { data: "ESTADO", title: "Estado" },
  { data: "CIDADE", title: "Cidade" },
  { data: "BAIRRO", title: "Bairro" },
  { data: "INSCRICAO", title: "Inscrição" },
  { data: "UF", title: "UF" },
  { data: "CNPJ", title: "CNPJ" },
  { data: "TELEFONE", title: "Telefone" }
];

$(document).ready(async function () {

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let embarque = parametros[parametros.length - 1];
  let aberto = true;
  const painelConferencia = (await CopiaParametro('EXPEDICAO', 2)) == 1;
  const scrollY_tabelaEmbarque = painelConferencia !== 0 ? '300px' : '500px';

  if (painelConferencia == 1) {
    $('#divTabelaConferencia').removeClass('d-none');
    $('#divCaixas').removeClass('d-none');
    $('#divCxConf').removeClass('d-none');
    $('#divSaldo').removeClass('d-none');
  }

  function criaTabelas(data) {
    try {
      criaDataTablePadrao('#tabelaEmbarque', false, false, false, true, true, true, scrollY_tabelaEmbarque, data, columnsTabelaEmbarque, [], [], [], [9], {}, 2, '', '', false, [], [7, 8, 10], false, false, false, false);
      if (painelConferencia !== 0) {
        criaDataTablePadrao('#tabelaConferencia', false, false, false, false, true, true, '200px', undefined, undefined, [], [], [], [], {}, 2, '', '', false, [], [2]);
        $('#tabelaConferencia_filter').addClass('d-none');
        $('#tabelaEmbarque_filter').addClass('d-none');
      }
    } catch (error) {
      $.LoadingOverlay('hide');
      msgAlerta(`Houve um problema ao criar a tabela: ${error.message}`)
      console.error(error.message);
    } finally {
      $('#txtNota').val('');
      if ($.fn.DataTable.isDataTable('#tabelaEmbarque')) {
        $("#tabelaEmbarque").DataTable().columns.adjust().draw(false);
      };
      $('#tabelaEmbarque').on('draw.dt', function () {
        $('.dropdown-toggle').dropdown();
      });
    };

    $('.btnVerificaOpcoes').on('click', function () {
      var $dropdownMenu = $(this).next('.dropdown-menu');
      $dropdownMenu.appendTo('body');
      $dropdownMenu.css({
        'position': 'absolute',
        'z-index': 1000
      });
    });
  };

  async function buscaEmbarque() {
    const numEmbarque = `NUMERO=${embarque}`
    const response = await requisicao("GET", "/Sisplan/embarque/V1/buscapornumero?", numEmbarque, null);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();

    if (response.status != 200) {
      msgErro(jsonStr[0].mensagem);
      return;
    }

    $("#txtNumero").val(jsonStr[0].NUMERO);
    moment($("#dtCadastro").val(jsonStr[0].DT_CADASTRO)).format('DD/MM/YYYY');
    const situacaoFechada = jsonStr[0].SITUACAO == '1';
    $('#radioFechado').prop('checked', situacaoFechada);
    $('#radioPendentes').prop('checked', !situacaoFechada);

    // for (let i = 0; i < jsonStr.length; i++) {
    //   $('#tabelaEmbarque').DataTable().row.add([
    //     jsonStr[i].FATURA,
    //     jsonStr[i].SERIE,
    //     jsonStr[i].CODCLI,
    //     jsonStr[i].NOME,
    //     jsonStr[i].CODTRANSP,
    //     jsonStr[i].NOME_TRANSP,
    //     jsonStr[i].CONFERIDO,
    //     jsonStr[i].QTDE_CAIXAS,
    //     jsonStr[i].PESO_BRUTO,
    //     jsonStr[i].VALOR,
    //     jsonStr[i].VOLUMES,
    //     jsonStr[i].ENDERECO,
    //     jsonStr[i].ESTADO,
    //     jsonStr[i].CIDADE,
    //     jsonStr[i].BAIRRO,
    //     jsonStr[i].INSCRICAO,
    //     jsonStr[i].UF,
    //     jsonStr[i].CNPJ,
    //     jsonStr[i].TELEFONE,
    //   ]);
    // }
    criaTabelas(jsonStr);

    $('#tabelaEmbarque').DataTable().draw(false);

    atualizaTotais();

    $('.itemTable').eq(2);

    if (painelConferencia == 1) {
      const resposta = await requisicao("GET", "/Sisplan/embarque/V1/buscaconferencia?", numEmbarque, null);

      if (!resposta) {
        return;
      }

      let jsonStrC = await resposta.json();

      if (resposta.status != 200) {
        msgErro(jsonStrC[0].mensagem);
        return;
      }

      for (let i = 0; i < jsonStrC.length; i++) {
        $('#tabelaConferencia').DataTable().row.add([
          jsonStrC[i].NOTAFISCAL,
          jsonStrC[i].CAIXA,
          jsonStrC[i].QTDE,
          jsonStrC[i].CONFERIDO
        ]);
      }
      $('#tabelaConferencia').DataTable().row().draw(false);
      atualizaTotaisConf()
    }

    if (jsonStr[0].SITUACAO == '1') {
      $('#radioFechado').prop('disabled', true)
      $('#radioPendentes').prop('disabled', true)
      $('#btnGravaEmbarque').addClass('d-none')
      $('#txtNota').prop("disabled", true)
      $('#btn-Nota').prop("disabled", true)
      $('#btn-limpa-Nota').prop("disabled", true)
      aberto = false;
    }

    bloqueiaCampoNumero();
    selecionaLinha();
  }

  if (embarque != "" && embarque != "create") {
    $.LoadingOverlay("show");
    try {
      buscaEmbarque()
    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível buscar os dados:`);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  if (embarque == 'create') {
    setaDatas();
  }

  $("#tabelaEmbarque tbody").on("click", "tr", function () {
    $("#tabelaEmbarque")
      .dataTable()
      .$("tr.selected")
      .removeClass("selected");
    $(this).addClass("selected");
  });

  async function mostraLinha(aFatura) {
    try {
      var table = $('#tabelaConferencia').DataTable();
      var filteredData = table.search(aFatura).draw(false);
    } catch (error) {
      console.log(error)
    }
  }

  function exibeBtnRemoveNota() {
    if (aberto) {
      $("#btnRemoveNota").removeClass("d-none")
    };
  };

  $("#btnRemoveNota").on("click", function () {
    $("#tabelaEmbarque").DataTable().row(".selected").remove().draw(false);
  });


  $("#tabelaEmbarque").on("click", "tr", async function () {
    const fatura = $("#tabelaEmbarque").DataTable().row($(this)).data()[0];
    mostraLinha(fatura)
    exibeBtnRemoveNota();
  });

  $('body').keydown(function (e) {
    if (((window.event.which === 13) || (window.event.which === 9)) && (getCookie('embarque_tela_cheia') == 'true')) {
      abreTelaCheia();
    }
    if (window.event.which === 113) {

      if (largMinima == $('.content-wrapper').css('min-height')) {
        abreTelaCheia();
        return;
      }
      fechaTelaCheia();
    }
  });

  function abreTelaCheia(executaCloseFullScreen = true) {
    try {
      const elem = document.querySelector('body');
      $('body').addClass('sidebar-collapse');
      $('#btnTelaCheia').addClass('d-none');
      $('#btnTelaReduzida').removeClass('d-none');
      $('#txtPedido').focus();

      if (executaCloseFullScreen) {
        if (elem.requestFullscreen) {
          elem.requestFullscreen();
        } else if (elem.mozRequestFullScreen) {
          elem.mozRequestFullScreen();
        } else if (elem.webkitRequestFullscreen) {
          elem.webkitRequestFullscreen();
        } else if (elem.msRequestFullscreen) {
          elem.msRequestFullscreen();
        }
        setCookie('embarque', true, 30);
      }

    } finally {
      if ($.fn.DataTable.isDataTable("#tabelaConferencia") && $.fn.DataTable.isDataTable("#tabelaEmbarque")) {
        $("#tabelaConferencia").DataTable().columns.adjust().draw(false);
        $("#tabelaEmbarque").DataTable().columns.adjust().draw(false);
      }
    }
  };

  function fechaTelaCheia(executaCloseFullScreen = true) {
    try {
      $('body').removeClass('sidebar-collapse');
      $('#btnTelaCheia').removeClass('d-none');
      $('#btnTelaReduzida').addClass('d-none');
      $('#txtPedido').focus();

      if (executaCloseFullScreen) {
        if (document.exitFullscreen) {
          document.exitFullscreen();
        }
        else if (document.mozCancelFullScreen) {
          document.mozCancelFullScreen();
        }
        else if (document.webkitExitFullscreen) {
          document.webkitExitFullscreen();
        }
        else if (document.msExitFullscreen) {
          document.msExitFullscreen();
        }

        setCookie('embarque', false, 30);
      }

    } finally {
      if ($.fn.DataTable.isDataTable("#tabelaConferencia") && $.fn.DataTable.isDataTable("#tabelaEmbarque")) {
        $("#tabelaConferencia").DataTable().columns.adjust().draw(false);
        $("#tabelaEmbarque").DataTable().columns.adjust().draw(false);
      }
    }
  };

  $('#btnGravaEmbarque').on('click', function () {
    gravaDados()
  })


  adicionaPesquisa();

  function adicionaPesquisa() {

    $("#btn-Nota").pesquisa_serverside(
      ['#txtNota'],
      ["NOTA.FATURA"],
      ["ENTIDADE.NOME"],
      `{
        "tabela":"NOTA", 
        "camposSelect":["NOTA.FATURA", "ENTIDADE.NOME", "NOTA.TRANSPORT"],
        "leftjoin": [
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA.CODCLI"},
          {"tabela": "TABTRAN", "condicao": "TABTRAN.CODIGO = NOTA.TRANSPORT"}
        ],
        "where": ["1=1 AND IMPRESSO <> 'C' AND IMPRESSO <> 'D'"]
      }`,
      'Pesquisa Nota'
    );

    $('#btn-limpa-Nota').on('click', function () { $('#txtNota').val(''); });

    $('#btn-Nota').on('click', async function () {
      const sNumero = $('#txtNumero').val();
      if (sNumero == '') {
        $('#txtNumero').val(await RetornaProximo('NOTA_EMBARQUE', 'NOTA_EMBARQUE', 'NUMERO', 6));
        bloqueiaCampoNumero();
      }
    })

    $('#txtNumero').on('blur', async function () {
      faturasListadas = true;
      const sNumero = $('#txtNumero').val()
      if (sNumero != 11) {
        buscaEmbarque()
      }
      if (sNumero == '') {
        $('#txtNumero').val(await RetornaProximo('NOTA_EMBARQUE', 'NOTA_EMBARQUE', 'NUMERO', 6));
        bloqueiaCampoNumero();
      } else if (await validaEmbarqueExistente(sNumero)) {
        window.location.href = (sNumero);
      } else {
        msgAlerta('Número de embarque inexistente, favor verificar.');
        $('#txtNumero').focus();
      }
    });

    $('#txtNota').on('blur', async function () {
      if ($('#txtNota').val() != '') {
        retornaDados();
      }
    })

    $('#txtNota').on('keydown', async function (event) {
      if (event.key == 'Enter') {
        $('#txtNota').trigger('blur');
      }
    });

    $('#txtNumCaixa').on('keydown', async function (event) {
      if ((event.key == 'Enter')) {
        $('#txtNumCaixa').trigger('blur');
      }
      $('#txtNumCaixa').focus();
    });

    $('#txtNumCaixa').on('blur', async function () {
      if ($('#txtNumCaixa').val() != '')
        alteraConferencia();
    });

    $("#voltarAcesso").on('click', function () {
      window.location.href = `${BASE_URI}/embarque`;
    })
  }

  async function buscaNota() {
    let filtros = ''
    const data = pegaChave('#txtNota');
    if (data.length < 5) {
      filtros = `CHAVE_NFE=${$('#txtNota').val()}`
    } else {
      filtros = `FATURA=${pegaChave("#txtNota")}`
    }
    return filtros
  }

  function atualizaTotais() {
    let qtde_Notas = 0;
    let qtde_Volumes = 0;
    let peso_Bruto = 0;
    let valor = 0;
    qtde_Notas += $('#tabelaEmbarque').DataTable().rows().count();
    qtde_Volumes += $('#tabelaEmbarque').DataTable().column(10).data().sum()
    peso_Bruto += $('#tabelaEmbarque').DataTable().column(8, {}).data().sum();
    valor += $('#tabelaEmbarque').DataTable().column(9, {}).data().sum();
    $('#txtTotalNotas').val(qtde_Notas);
    $('#txtTotalVolumes').val(qtde_Volumes);
    $('#txtPesoBruto').val(peso_Bruto.toFixed(2));
    $('#txtValorTotal').val(valor.toFixed(2));
  }

  if (painelConferencia == 1) {
    function atualizaTotaisConf() {
      let qtde_Caixas = 0;
      let qtde_CaixaConf = 0;
      let qtde_Saldo = 0;
      qtde_Caixas += $('#tabelaConferencia').DataTable().column(1, {}).data().count();
      qtde_CaixaConf += $('#tabelaConferencia').DataTable().column(3).data().toArray().filter((CONFERIDO) => CONFERIDO == 'S').length
      qtde_Saldo += $('#tabelaConferencia').DataTable().column(3).data().toArray().filter((CONFERIDO) => CONFERIDO == 'N').length
      $('#txtCaixa').val(qtde_Caixas);
      $('#txtCxConf').val(qtde_CaixaConf);
      $('#txtSaldo').val(qtde_Saldo);
    }
  }

  async function retornaDados() {
    if ($('#radioFechado').prop('disabled') == true) {
      msgAlerta("Romaneio já fechado, impossível continuar")
      return
    }

    verificaSeExisteNota = []
    verificaSeExisteTransporte = []
    try {
      $.LoadingOverlay('show')
      const url = '/sisplan/embarque/v1/pesquisanotaunica?'
      const params = await buscaNota()


      const response = await requisicao('GET', url, params, 150000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      sFatura = jsonStr[0].FATURA

      const notaEmbarque = await verificaNotaEmbarque(sFatura)
      if (notaEmbarque == true) {
        msgAlerta('Nota já vinculada a outro romaneio, verifique!')
        $('#txtNota').val('')
        return
      }

      if ($.fn.DataTable.isDataTable("#tabelaEmbarque")) {
        if ($('#tabelaEmbarque').DataTable().column(0).data().toArray().length !== 0) {
          verificaSeExisteNota = $('#tabelaEmbarque').DataTable().column(0).data().toArray()
          for (let i = 0; i < verificaSeExisteNota[i]; i++) {
            verificaNota = verificaSeExisteNota[i];
            if (jsonStr[0].FATURA === verificaNota) {
              msgAlerta('Nota já adicionada ao embarque, verifique!');
              $('#txtNota').val('');
              return;
            };
          };

          validaSeExisteTransporte = $('#tabelaEmbarque').DataTable().column(4).data().toArray()
          for (let i = 0; i < validaSeExisteTransporte[i]; i++) {
            if (jsonStr[0].CODTRANSP != validaSeExisteTransporte[i]) {
              msgAlerta('Tranportadora da nota diferente da transportadora bipada, verifique!');
              $('#txtNota').val('');
              return;
            };
          };
        };
      };
      // jsonStr.map(element => {
      //   $('#tabelaEmbarque').DataTable().row.add([
      //     element.FATURA,
      //     element.SERIE,
      //     element.CODCLI,
      //     element.NOME,
      //     element.CODTRANSP,
      //     element.NOME_TRANSP,
      //     element.CONFERIDO,
      //     element.QTDE_CAIXAS,
      //     element.PESO_BRUTO,
      //     element.VALOR,
      //     element.VOLUMES,
      //     element.ENDERECO,
      //     element.ESTADO,
      //     element.CIDADE,
      //     element.BAIRRO,
      //     element.INSCRICAO,
      //     element.UF,
      //     element.CNPJ,
      //     element.TELEFONE,
      //   ]).draw(false);
      //   $('#txtNota').val('')
      //   atualizaTotais();
      //   return 'ok';
      // });
      criaTabelas(jsonStr);

      if (painelConferencia == 1) {
        await buscaTabelaConferencia(sFatura)
      }

    } catch (error) {
      console.error(error);
    } finally {
      if ($.fn.DataTable.isDataTable('#tabelaEmbarque')) {
        $("#tabelaEmbarque").DataTable().columns.adjust().draw(false);
      }
      $.LoadingOverlay("hide");
      $("#txtNota").focus()
      const sNumero = $('#txtNumero').val()
      if (sNumero == '') {
        $('#txtNumero').trigger('blur')
      }
    }
  }

  async function verificaNotaEmbarque(pFatura) {
    const pesquisaParam = {
      tabela: 'NOTA_EMBARQUE',
      camposSelect: [`FATURA`],
      where: [`FATURA = '${pFatura}'`]
    }

    const resposta = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (resposta.length == 0) {
      return false
    }
    return true
  }

  async function buscaTabelaConferencia(sFatura) {
    try {
      const pesquisaParam = {
        tabela: 'PEDIDO3',
        camposSelect: [
          `NOTAFISCAL, CAIXA, SUM(QTDE_F) QTDE, 'N' CONFERIDO`
        ],
        where: [`NOTAFISCAL = '${sFatura}'`],
        groupby: [
          'CAIXA, NOTAFISCAL'
        ]
      }

      const jsonStrConf = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      jsonStrConf.map(e => {
        $('#tabelaConferencia').DataTable().row.add([
          e.NOTAFISCAL,
          e.CAIXA,
          e.QTDE,
          e.CONFERIDO
        ]).draw(false);
        atualizaTotaisConf();
        return 'ok';
      })

    } catch {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
    }

  }


  $('#radioPendetes').prop('checked', true)

  async function selecionaLinha() {
    $('#tabelaEmbarque tr:eq(1)').trigger('click')
  }

  async function selecionaLinhaNota(pFatura) {
    const tabelaEmbarque = $('#tabelaEmbarque').DataTable().column(0).data();
    length = tabelaEmbarque.length - 1;
    for (let i = 0; i < tabelaEmbarque.length; i++) {
      const numFaturaEmbarque = tabelaEmbarque[i];
      if (numFaturaEmbarque == pFatura) {
        const tabelaEmbarqueConf = $('#tabelaEmbarque').DataTable().columns(6).row(i).data()
        tabelaEmbarqueConf[6] = 'S'
        $('#tabelaEmbarque').DataTable().row(i).remove().draw(false)
        $('#tabelaEmbarque').DataTable().row.add(tabelaEmbarqueConf).draw(false)
        $($('#tabelaEmbarque tbody tr')[length]).click();
      }
    }
  }

  async function alteraConferencia() {
    $.LoadingOverlay('show')
    try {
      if ($('#radioFechado').is(':checked') == true) {
        msgAlerta('Romaneio já está finalizado. Impossível continuar!')
        return
      }

      numCaixa = $('#txtNumCaixa').val()
      let tabelaConferencia = $('#tabelaConferencia').DataTable().rows().data()
      for (let i = 0; i < tabelaConferencia.length; i++) {
        if (numCaixa == tabelaConferencia[i][1]) {
          tabelaConferencia[i][3] = 'S'
          $('#tabelaConferencia').DataTable().row(i).remove().draw(false)
          $('#tabelaConferencia').DataTable().row.add(tabelaConferencia[i]).draw(false)
          selecionaLinhaNota(tabelaConferencia[i][0])

        }
      }
    } catch {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
      atualizaTotaisConf()
    }
  }

  $('#tabelaEmbarque').on('click', '.btn-excluir', async function () {
    if (aberto) {
      $('#tabelaEmbarque').DataTable().row($(this).parents('tr')).remove().draw(false);
      atualizaTotais()
      atualizaTotaisConf()
    } else {
      msgAlerta("Romaneio já está fechado, impossível continuar!")
    };
  });

  // async function verificaSituacao() {
  //   if ($('#radioPendentes').is(':checked') == false &
  //     $('#radioFechado').is(':checked') == false) {
  //     return false;
  //   }
  // }

  async function verificaBipada() {
    const qtde_conf = $('#tabelaEmbarque').DataTable().column(6).data().toArray().filter((CONFERIDO) => CONFERIDO == 'S').length
    const qtde_caixas = $('#tabelaConferencia').DataTable().column(1, {}).data().count()

    if (qtde_conf < qtde_caixas) {
      return false;
    };
    return true;
  }

  async function gravaDados() {
    $.LoadingOverlay('show');
    try {
      // const situacao = await verificaSituacao()
      // if (situacao == false) {
      //   msgAlerta('A situação de embarque deve ser selecionada!')
      //   return
      // }
      if (painelConferencia == 1) {
        if ($('#txtSaldo').val() != 0) {
          msgAlerta('É necessário conferir todas as caixas')
        }
      }

      verificaBipada = await verificaBipada()
      if (verificaBipada == false) {
        msgAlerta('Há caixas que não foram conferidas. Impossível continuar!')
        return;
      }

      if ($('#radioFechado').prop('disabled') == true) {
        msgAlerta("Romaneio já fechado, impossível continuar")
        return
      }

      const tabelaConferecia = $('#tabelaConferencia').DataTable().rows().data();
      const tabelaEmbarque = $('#tabelaEmbarque').DataTable().rows().data();

      if (tabelaEmbarque.length === 0) {
        msgAlerta("Não é possível gravar sem uma fatura informada. Verifique!");
        return;
      };

      const Embarque = tabelaEmbarque.map((dados) => {
        const objeto = {
          Fatura: dados.FATURA,
          Serie: dados.SERIE,
          Transport: dados.CODTRANSP,
          Numero: pegaValor('#txtNumero'),
          Dt_Cadastro: pegaValor('#dtCadastro'),
          Situacao: $('#radioFechado').prop('checked') ? '1' : '0',
        }
        return objeto;
      });

      const Conferencia = tabelaConferecia.map((dados) => {
        const objeto = {
          NotaFiscal: dados[0],
          Caixa: dados[1],
          Qtde: dados[2],
          Conferido: dados[3]
        }
        return objeto
      });

      const body = {
        Embarque: Embarque.toArray(),
        Conferencia: Conferencia.toArray(),
      }

      const url = `/sisplan/embarque/v1/gravaembarque?`
      const response = await requisicao('POST', url, '', `JSON=${JSON.stringify(body)}&NUMERO=${embarque}`, 90000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        msgAlerta(`Não foi possível gravar os dados do embarque, verifique!`);
        $.LoadingOverlay('hide');
        return;
      }
      criaMensagemSucesso('Embarque gravado com sucesso!', () => { window.location.href = `${BASE_URI}/embarque`; });

    } catch (error) {
      console.error(error);
      msgAlerta(`Não foi possível gravar os dados do embarque`);
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function validaEmbarqueExistente(sNumero) {
    const dadosSelect = {
      tabela: 'NOTA_EMBARQUE',
      camposSelect: ['NUMERO'],
      where: [`NUMERO = '${sNumero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    if (retornoSelect.length == 0) {
      return false;
    }
    return true;
  };

  async function setaDatas() {
    await setarDataAtual('dtCadastro');
  };

  function bloqueiaCampoNumero() {
    $('#txtNumero').prop('disabled', true);
    $('#txtNumero').prop('readonly', true);
  }

  $(".div-infos").on("click", function () {
    $(this).toggleClass("clicado");
    $(".div-infos.clicado").not(this).removeClass("clicado");
  });
});
