<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Cotações</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.259.2.1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.259.2.1">
  <!--e1Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.259.2.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.259.2.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.259.2.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.259.2.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.259.2.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.259.2.1">
  <link rel="stylesheet" href="https://cdn.datatables.net/select/1.6.0/css/select.dataTables.min.css">
  <link rel="stylesheet" href="../dist/css/PesquisaVariosSelect2.css?versao=3.259.2.1">
  <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.259.2.1">

  <style>
    .table.dataTable tbody td,
    .table.dataTable thead {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    .content-wrapper {
      margin-left: 0px !important;
    }

    .main-header,
    .main-sidebar {
      display: none;
    }

    .table.dataTable tr td,
    .table.dataTable tr td,
    .table.dataTable th {
      padding: 4px 12px;
    }

    .pagination {
      justify-content: end !important;
    }

    .dataTables_wrapper .row {
      margin-right: 0 !important;
      margin-left: 0 !important;
    }

    .placeholder-lowercase::placeholder {
      text-transform: none;
    }

    #progressbar {
      box-sizing: border-box;
    }

    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 50%;
      float: left;
      position: relative
    }

    .main-container {
      display: block;
      text-align: center;
      position: relative;
      margin-top: 20px;
      unicode-bidi: isolate;


      fieldset:not(:first-of-type) {
        display: none;
      }
    }

    .step-container {
      text-align: left;
      padding: 20px 10px 30px 10px;
      width: 100%;
      margin-bottom: 20px;
      position: relative;
      color: var(--font-color);
      z-index: 2;
      background: var(--card-color);
      border-radius: 8px;
    }

    #containerUltimasCompras {
      display: flex;
      flex-direction: column;
      max-height: 310px;
      overflow-y: auto;
      gap: 4px;
    }

    .card {
      box-shadow: none !important;
      border-radius: 0 !important;
      margin-bottom: 0 !important;
    }

    .card-header {
      box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card-header {
      border-bottom: 1px dashed #ddd;
      box-shadow: none !important;
    }

    .card-body {
      padding-left: 1.25rem !important;
      padding-top: 0px;
      padding-bottom: 0px;
      padding-right: 1.25rem !important;
    }

    .fa-angle-right,
    .fa-angle-down {
      color: #343a40;
    }

    .dataTables_wrapper .col-sm-12 {
      padding-left: 0 !important;
      padding-right: 0 !important;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>
    <div class="wrapper">


      <div id="myModal" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 id="myModalLabel" class="modal-title"></h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <p id="myModalText"></p>
            </div>
            <div class="modal-footer">
              <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
              <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
            </div>
          </div>
        </div>
      </div>

      <div class="content-wrapper">
        <section class="content">
          <div class="content-header p-0">
            <div class="container-fluid">
              <div class="row mb-2">
                <div class="col-sm-6 flex">
                </div>
                <div class="col-sm-6">
                </div>
              </div>
            </div>
            <div class="row mt-0">
              <div class="col-12 p-0 mt-3 mb-2">
                <div class="card p-0 mb-0">
                  <div class="card-header d-flex p-0 ml-4 align-items-start" style="border: none!important;box-shadow:none!important; gap: 10px;">
                    <div class="flex flex-column">
                      <div class="flex my-2">
                        <h2 class="mb-0 text-center flex align-items-center">
                          <span class="ml-2">Cadastro de Cotações</span>
                          <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                            <i class="fas fa-question-circle"></i>
                          </button>
                        </h2>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row mx-0 px-0">
                  <div class="col-12 mx-0 px-4">
                    <div id="msform">
                      <ul id="progressbar">
                        <li class="active" id="account"><strong>Geral</strong></li>
                        <li id="payment"><strong>Itens</strong></li>
                      </ul>
                      <p>Preencha os dados e clique em avançar até a conclusão da cotação</p>
                      <fieldset id="fieldset1">
                        <div class="step-container">
                          <div class="form-row col-12">
                            <div class="col-xl-6 col-12">
                              <form class="flex" style="gap: 8px" id="form">
                                <div class="col-xl-2 col-6 form-group px-0 mx-0">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtNumero">Número:</label>
                                  <input type="text" class="input-default focus form-control" id="txtNumero" name="numero" placeholder="Número" disabled>
                                </div>
                                <div class="col-xl-2 col-6 form-group px-0 mx-0">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtValidade">Validade:</label>
                                  <input type="date" class="input-default focus form-control" value="<?php echo date('Y-m-d'); ?>" id="txtValidade" name="validade">
                                </div>
                                <div class="col-xl-2 col-12 form-group px-0 mx-0">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtUsuario">Usuário:</label>
                                  <input type="text" class="input-default focus form-control" id="txtUsuario" name="usuario" placeholder="Usuário" disabled>
                                </div>
                              </form>
                              <h4>Últimas Compras</h4>
                              <div id="containerUltimasCompras">
                              </div>
                            </div>
                            <div class="col-xl-6 col-12">
                              <form class="flex" style="gap: 8px" id="formFornecedor">
                                <div class="col-xl-6 col-12 form-group px-0 mx-0">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtFornecedor">Fornecedores:</label>
                                  <div class="input-group">
                                    <select class="js-example-programmatic js-states form-control" id="txtFornecedor" name="fornecedor" multiple="multiple">
                                    </select>
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnFornecedor" name="btnFornecedor" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnLimpaFornecedor" name="btnLimpaFornecedor" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>
                                <div class="form-group flex justify-content-start align-items-end">
                                  <button type="submit" class="btn btn-danger btn-sisp" id="btnAdicionarFornecedor" style="max-height: 38px">Adicionar</button>
                                </div>
                              </form>
                              <h4>Fornecedores</h4>
                              <div class="table-responsive">
                                <table id="tabelaFornecedores" class="table table-select table-hover" width="100%">
                                  <thead>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                            <div class="col-12">
                              <h4>Itens</h4>
                              <div class="table-responsive">
                                <table id="tabelaItens" class="table table-select table-hover" width="100%">
                                  <thead>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                          </div>
                          <div class="form-row col-12" style="gap: 8px; text-align: end;">
                            <div class="col-12">
                              <button type="button" class="btn btn-secondary btn-sisp" id="btnVoltar" style="max-height: 38px">Voltar</button>
                              <button type="submit" form="form" class="btn btn-danger btn-sisp" id="btnAvancar" style="max-height: 38px">Avançar</button>
                            </div>
                          </div>
                        </div>
                      </fieldset>
                      <fieldset id="fieldset2">
                        <div class="step-container">
                          <div class="col-12">
                            <button class="btn btn-danger btn-sisp" id="btnSolicitacoes"></span> Solicitações</button>
                          </div>
                          <div class="col-12 collapse show mt-2" id="multiCollapse">
                            <div class="card">
                              <div class="card card-header" role="tab" id="abaMaterial">
                                <a style="width:100%;" data-toggle="collapse" data-parent="#itensMaterial" href="#itensMaterial" aria-expanded="true" aria-controls="collapseOne">
                                  <div class="row">
                                    <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                      <i class="fas fa-angle-right"></i>
                                    </div>
                                    <div class="col-11">
                                      <h4 class="title-page" id="labelMaterial">
                                        Material
                                        <span id="quantidadeMateriais"></span>
                                      </h4>
                                    </div>
                                  </div>
                                </a>
                              </div>
                              <div class="collapse" id="itensMaterial">
                                <div class="card-body">
                                  <form class="pt-2 form-row" id="formMaterial">
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtMaterial">Material:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtMaterial" name="material" placeholder="Material">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnMaterial" name="btnMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaMaterial" name="btnLimpaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtCorMaterial">Cor:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control controleMaterial" id="txtCorMaterial" name="cor" placeholder="Cor" disabled>
                                        <div class="input-group-append">
                                          <button class="btn bg-danger controleMaterial" id="btnCorMaterial" name="btnCorMaterial" data-button="absolute" type="button" disabled><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger controleMaterial" id="btnLimpaCorMaterial" name="btnLimpaCorMaterial" type="button" disabled><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtSolicitacaoMaterial">Solicitação:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtSolicitacaoMaterial" name="solicitacao" placeholder="Solicitação">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnSolicitacaoMaterial" name="btnSolicitacaoMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaSolicitacaoMaterial" name="btnLimpaSolicitacaoMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtCentroCustoMaterial">Centro de Custo:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtCentroCustoMaterial" name="centroCusto" placeholder="Centro de Custo">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnCentroCustoMaterial" name="btnCentroCustoMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaCentroCustoMaterial" name="btnLimpaCentroCustoMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtMarcaMaterial">Marca:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtMarcaMaterial" name="marca" placeholder="Marca">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnMarcaMaterial" name="btnMarcaMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaMarcaMaterial" name="btnLimpaMarcaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtEspecificacaoMaterial">Especificação:</label>
                                      <input type="text" class="input-default focus form-control" id="txtEspecificacaoMaterial" name="especificacao" placeholder="Especificação">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidadeMaterial">Unidade:</label>
                                      <input type="text" class="input-default focus form-control text-uppercase" disabled id="txtUnidadeMaterial" name="unidade" placeholder="UN">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidadeCompraMaterial">Uni Compra:</label>
                                      <input type="text" class="input-default focus form-control text-uppercase" disabled id="txtUnidadeCompraMaterial" name="unidadeCompra" placeholder="UN">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtQuantidadeMaterial">Quantidade:</label>
                                      <input type="text" class="input-default focus form-control text-right campoFloat" id="txtQuantidadeMaterial" name="quantidade" placeholder="0.00000">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtQuantidadeCotadaMaterial">Qtde Cotada:</label>
                                      <input type="text" class="input-default focus form-control text-right" disabled id="txtQuantidadeCotadaMaterial" name="quantidadeCotada" placeholder="0.00000">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtEntregaMaterial">Entrega:</label>
                                      <input type="date" class="input-default focus form-control" id="txtEntregaMaterial" name="entrega">
                                    </div>
                                    <div class="form-row col-12 mb-2" style="gap: 8px; text-align: end;">
                                      <div class="col-12">
                                        <button type="submit" class="btn btn-danger btn-sisp" id="btnAdicionarMaterial" style="max-height: 38px">Adicionar</button>
                                      </div>
                                    </div>
                                    <div class="table-responsive">
                                      <table id="tabelaMateriais" class="table table-select table-hover" width="100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                      </table>
                                    </div>
                                  </form>
                                </div>
                              </div>
                              <div class="card card-header" role="tab" id="abaProduto">
                                <a style="width:100%;" data-toggle="collapse" data-parent="#itensProduto" href="#itensProduto" aria-expanded="true" aria-controls="collapseTwo">
                                  <div class="row">
                                    <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                      <i class="fas fa-angle-right"></i>
                                    </div>
                                    <div class="col-11">
                                      <h4 class="title-page" id="labelProduto">
                                        Produto
                                        <span id="quantidadeProdutos"></span>
                                      </h4>
                                    </div>
                                  </div>
                                </a>
                              </div>
                              <div class="collapse" id="itensProduto">
                                <div class="card-body">
                                  <form class="pt-2 form-row" id="formProduto">
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtProduto">Produto:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtProduto" name="produto" placeholder="Produto">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaProduto" name="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtCorProduto">Cor:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control controleProduto" id="txtCorProduto" name="cor" placeholder="Cor" disabled>
                                        <div class="input-group-append">
                                          <button class="btn bg-danger controleProduto" id="btnCorProduto" name="btnCorProduto" data-button="absolute" type="button" disabled><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger controleProduto" id="btnLimpaCorProduto" name="btnLimpaCorProduto" type="button" disabled><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtTamanhoProduto">Tamanho:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control controleProduto" id="txtTamanhoProduto" name="tamanho" placeholder="Tamanho" disabled>
                                        <div class="input-group-append">
                                          <button class="btn bg-danger controleProduto" id="btnTamanhoProduto" name="btnTamanhoProduto" data-button="absolute" type="button" disabled><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger controleProduto" id="btnLimpaTamanhoProduto" name="btnLimpaTamanhoProduto" type="button" disabled><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtSolicitacaoProduto">Solicitação:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtSolicitacaoProduto" name="solicitacao" placeholder="Solicitação">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnSolicitacaoProduto" name="btnSolicitacaoProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaSolicitacaoProduto" name="btnLimpaSolicitacaoProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtCentroCustoProduto">Centro de Custo:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtCentroCustoProduto" name="centroCusto" placeholder="Centro de Custo">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnCentroCustoProduto" name="btnCentroCustoProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaCentroCustoProduto" name="btnLimpaCentroCustoProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtMarcaProduto">Marca:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtMarcaProduto" name="marca" placeholder="Marca">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnMarcaProduto" name="btnMarcaProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaMarcaProduto" name="btnLimpaMarcaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtEspecificacaoProduto">Especificação:</label>
                                      <input type="text" class="input-default focus form-control" id="txtEspecificacaoProduto" name="especificacao" placeholder="Especificação">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidadeProduto">Unidade:</label>
                                      <input type="text" class="input-default focus form-control text-uppercase" disabled id="txtUnidadeProduto" name="unidade" placeholder="UN">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidadeCompraProduto">Uni Compra:</label>
                                      <input type="text" class="input-default focus form-control text-uppercase" disabled id="txtUnidadeCompraProduto" name="unidadeCompra" placeholder="UN">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtQuantidadeProduto">Quantidade:</label>
                                      <input type="text" class="input-default focus form-control text-right campoFloat" id="txtQuantidadeProduto" name="quantidade" placeholder="0.00000">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtQuantidadeCotadaProduto">Qtde Cotada:</label>
                                      <input type="text" class="input-default focus form-control text-right" disabled id="txtQuantidadeCotadaProduto" name="quantidadeCotada" placeholder="0.00000">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtEntregaProduto">Entrega:</label>
                                      <input type="date" class="input-default focus form-control" id="txtEntregaProduto" name="entrega">
                                    </div>
                                    <div class="form-row col-12 mb-2" style="gap: 8px; text-align: end;">
                                      <div class="col-12">
                                        <button type="submit" class="btn btn-danger btn-sisp" id="btnAdicionarProduto" style="max-height: 38px">Adicionar</button>
                                      </div>
                                    </div>
                                    <div class="table-responsive">
                                      <table id="tabelaProdutos" class="table table-select table-hover" width="100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                      </table>
                                    </div>
                                  </form>
                                </div>
                              </div>
                              <div class="card card-header" role="tab" id="abaServico">
                                <a style="width:100%;" data-toggle="collapse" data-parent="#itensServico" href="#itensServico" aria-expanded="true" aria-controls="collapseThree">
                                  <div class="row">
                                    <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                      <i class="fas fa-angle-right"></i>
                                    </div>
                                    <div class="col-11">
                                      <h4 class="title-page" id="labelServico">
                                        Serviço
                                        <span id="quantidadeServicos"></span>
                                      </h4>
                                    </div>
                                  </div>
                                </a>
                              </div>
                              <div class="collapse" id="itensServico">
                                <div class="card-body">
                                  <form class="pt-2 form-row" id="formServico">
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtServico">Serviço:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtServico" name="servico" placeholder="Serviço">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnServico" name="btnServico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaServico" name="btnLimpaServico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtSolicitacaoServico">Solicitação:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtSolicitacaoServico" name="solicitacao" placeholder="Solicitação">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnSolicitacaoServico" name="btnSolicitacaoServico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaSolicitacaoServico" name="btnLimpaSolicitacaoServico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtCentroCustoServico">Centro de Custo:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtCentroCustoServico" name="centroCusto" placeholder="Centro de Custo">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnCentroCustoServico" name="btnCentroCustoServico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaCentroCustoServico" name="btnLimpaCentroCustoServico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-12 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtMarcaServico">Marca:</label>
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control" id="txtMarcaServico" name="marca" placeholder="Marca">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnMarcaServico" name="btnMarcaServico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaMarcaServico" name="btnLimpaMarcaServico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-xl-3 col-4 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtEspecificacaoServico">Especificação:</label>
                                      <input type="text" class="input-default focus form-control" id="txtEspecificacaoServico" name="especificacao" placeholder="Especificação">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidadeServico">Unidade:</label>
                                      <input type="text" class="input-default focus form-control text-uppercase" disabled id="txtUnidadeServico" name="unidade" placeholder="UN">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidadeCompraServico">Uni Compra:</label>
                                      <input type="text" class="input-default focus form-control text-uppercase" disabled id="txtUnidadeCompraServico" name="unidadeCompra" placeholder="UN">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtQuantidadeServico">Quantidade:</label>
                                      <input type="text" class="input-default focus form-control text-right campoFloat" id="txtQuantidadeServico" name="quantidade" placeholder="0.00000">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtQuantidadeCotadaServico">Qtde Cotada:</label>
                                      <input type="text" class="input-default focus form-control text-right" disabled id="txtQuantidadeCotadaServico" name="quantidadeCotada" placeholder="0.00000">
                                    </div>
                                    <div class="col-xl-1 col-6 form-group">
                                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtEntregaServico">Entrega:</label>
                                      <input type="date" class="input-default focus form-control" id="txtEntregaServico" name="entrega">
                                    </div>
                                    <div class="form-row col-12 mb-2" style="gap: 8px; text-align: end;">
                                      <div class="col-12">
                                        <button type="submit" class="btn btn-danger btn-sisp" id="btnAdicionarServico" style="max-height: 38px">Adicionar</button>
                                      </div>
                                    </div>
                                    <div class="table-responsive">
                                      <table id="tabelaServicos" class="table table-select table-hover" width="100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                      </table>
                                    </div>
                                  </form>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="form-row col-12 mt-3" style="gap: 8px; text-align: end;">
                            <div class="col-12">
                              <button type="button" class="btn btn-secondary btn-sisp" id="btnVoltar2" style="max-height: 38px">Voltar</button>
                              <button type="button" class="btn btn-danger btn-sisp" id="btnGravar" style="max-height: 38px">Gravar</button>
                            </div>
                          </div>
                        </div>
                      </fieldset>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>
    </div>
  </main>

  <div class="modal fade" data-backdrop="static" id="modalSolicitacoes" tabindex="-1" role="dialog" aria-labelledby="modalSolicitacoes" aria-hidden="true">
    <div class="modal-dialog" style="min-width: 80%; min-height: 100%">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Itens de Solicitações</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="form-row">
            <div class="form-group col-xl-1 col-3">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtSolicitacaoDeSolicitacoes">Solicitação de:</label>
              <input type="text" class="input-default focus form-control" id="txtSolicitacaoDeSolicitacoes" name="txtSolicitacaoDeSolicitacoes" placeholder="000000000" maxlength="9">
            </div>
            <div class="form-group col-xl-1 col-3">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtSolicitacaoAteSolicitacoes">Solicitação até:</label>
              <input type="text" class="input-default focus form-control" id="txtSolicitacaoAteSolicitacoes" name="txtSolicitacaoAteSolicitacoes" placeholder="999999999" maxlength="9">
            </div>
            <div class="form-group col-xl col-3">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmissaoDeSolicitacoes">Emissão de:</label>
              <input type="date" value="1200-01-01" max="2500-12-31" class="input-default focus form-control validate" id="txtEmissaoDeSolicitacoes">
            </div>
            <div class="form-group col-xl col-3">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmissaoAteSolicitacoes">Emissão até:</label>
              <input type="date" value="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtEmissaoAteSolicitacoes">
            </div>
            <div class="form-group col-xl col-3">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtEntregaDeSolicitacoes">Entrega de:</label>
              <input type="date" value="1200-01-01" max="2500-12-31" class="input-default focus form-control validate" id="txtEntregaDeSolicitacoes">
            </div>
            <div class="form-group col-xl col-3">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtEntregaAteSolicitacoes">Entrega até:</label>
              <input type="date" value="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtEntregaAteSolicitacoes">
            </div>
            <div class="form-group col-xl col-md-3 col-6">
              <label data-error="wrong" class="labelGeral" data-success="right" for="selectTipoItemSolicitacoes">Tipo Item:</label>
              <div class="input-group">
                <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectTipoItemSolicitacoes" aria-describedby="tipoError" class="custom-select focus">
                  <option value="">Todos</option>
                  <option value="M">Material</option>
                  <option value="P">Produto</option>
                  <option value="S">Serviço</option>
                </select>
              </div>
            </div>
            <div class="form-group col-xl-3 col-md-6 col-12">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtEspecificacaoSolicitacoes">Especificação:</label>
              <input type="text" class="input-default focus form-control" id="txtEspecificacaoSolicitacoes" name="txtEspecificacaoSolicitacoes" placeholder="Especificação">
            </div>
            <div class="form-group col-xl-4 col-md-6 col-12">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtSolicitanteSolicitacoes">Solicitante:</label>
              <div class="input-group">
                <select class="js-example-programmatic js-states form-control" id="txtSolicitanteSolicitacoes" name="txtSolicitanteSolicitacoes" multiple="multiple">
                </select>
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnSolicitanteSolicitacoes" name="btnSolicitanteSolicitacoes" data-button="absolute" type="button">
                    <i class="m-0 p-0 fas fa-search"></i>
                  </button>
                  <button class="btn bg-danger" id="btnLimpaSolicitanteSolicitacoes" name="btnLimpaSolicitanteSolicitacoes" type="button">
                    <i class="m-0 p-0 fas fa-trash"></i>
                  </button>
                </div>
              </div>
            </div>
            <div class="form-group col-xl-4 col-md-6 col-12">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCompradorSolicitacoes">Comprador:</label>
              <div class="input-group">
                <select class="js-example-programmatic js-states form-control" id="txtCompradorSolicitacoes" name="txtCompradorSolicitacoes" multiple="multiple">
                </select>
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCompradorSolicitacoes" name="btnCompradorSolicitacoes" data-button="absolute" type="button">
                    <i class="m-0 p-0 fas fa-search"></i>
                  </button>
                  <button class="btn bg-danger" id="btnLimpaCompradorSolicitacoes" name="btnLimpaCompradorSolicitacoes" type="button">
                    <i class="m-0 p-0 fas fa-trash"></i>
                  </button>
                </div>
              </div>
            </div>
            <div class="form-group col-xl-4 col-md-6 col-12">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtTipoSolicitacoes">Tipo:</label>
              <div class="input-group">
                <select class="js-example-programmatic js-states form-control" id="txtTipoSolicitacoes" name="txtTipoSolicitacoes" multiple="multiple">
                </select>
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnTipoSolicitacoes" name="btnTipoSolicitacoes" data-button="absolute" type="button">
                    <i class="m-0 p-0 fas fa-search"></i>
                  </button>
                  <button class="btn bg-danger" id="btnLimpaTipoSolicitacoes" name="btnLimpaTipoSolicitacoes" type="button">
                    <i class="m-0 p-0 fas fa-trash"></i>
                  </button>
                </div>
              </div>
            </div>
            <div class="flex col-12 justify-content-between mb-2">
              <span class="text-lg text-red">Duplo clique no item para adicioná-lo à cotação</span>
              <button type="button" class="btn btn-primary btn-sisp" id="btnConsultarSolicitacoes" style="max-height: 38px"><i class="m-0 p-0 fas fa-search"></i>Consultar</button>
            </div>
            <div class="table-responsive">
              <table id="tabelaItensSolicitacoes" class="table table-select table-hover" width="100%">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <div class="modal-footer px-2">
          <button class="btn btn-danger btn-sisp" id="btnLimparFiltrosSolicitacoes"><span class="fas fa-trash"></span>Limpar Filtros</button>
          <button class="btn btn-danger btn-sisp" class="close" data-dismiss="modal" aria-label="Close" id="btnFecharSolicitacoes">Fechar</button>
        </div>
      </div>
    </div>
  </div>

  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  <script src="../plugins/jquery/jquery.min.js?versao=3.259.2.1"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.259.2.1"></script>
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.259.2.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.259.2.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.259.2.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.259.2.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.259.2.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.259.2.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.259.2.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.259.2.1"></script>
  <script src="../dist/js/dataTables.keyTable.js?versao=3.259.2.1"></script>
  <script src="../utils/funcoes.js?versao=3.259.2.1"></script>
  <script src="../utils/cookies.js?versao=3.259.2.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.259.2.1"></script>
  <script src="../dist/js/jquery.mask.min.js?versao=3.259.2.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.259.2.1"></script>
  <script src="https://cdn.datatables.net/select/1.6.0/js/dataTables.select.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
  <script src="../plugins/select2/js/select2.full.min.js?versao=3.259.2.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('COTACAO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/cotacao/cadastro_cotacao/cotacao.js?versao=3.259.2.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>